/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.net.server.impl;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.quickserver.net.server.ClientHandler;
import org.quickserver.net.server.ClientIdentifier;
import org.quickserver.net.server.impl.BasicClientIdentifier;
import org.quickserver.net.server.impl.SyncClientIdentifier;

public class OptimisticClientIdentifier
extends BasicClientIdentifier {
    private static final Logger logger = Logger.getLogger(OptimisticClientIdentifier.class.getName());
    private ClientIdentifier backupClientIdentifier;
    private static final int MAX_TRY_COUNT = 4;

    public ClientHandler findFirstClientById(String id) {
        return this.findFirstClientById(id, 0);
    }

    private ClientHandler findFirstClientById(String id, int callCount) {
        ClientHandler foundClientHandler = null;
        try {
            Iterator iterator = this.findAllClient();
            while (iterator.hasNext() && (foundClientHandler = this.checkClientId((ClientHandler)iterator.next(), id)) == null) {
            }
        }
        catch (ConcurrentModificationException e) {
            if (callCount < 4) {
                foundClientHandler = this.findFirstClientById(id, ++callCount);
            }
            logger.finest("Going for backup..");
            foundClientHandler = this.getBackupClientIdentifier().findFirstClientById(id);
        }
        return foundClientHandler;
    }

    public Iterator findAllClientById(String pattern) {
        return this.findAllClientById(pattern, 0);
    }

    private Iterator findAllClientById(String pattern, int callCount) {
        ArrayList<ClientHandler> list = new ArrayList<ClientHandler>();
        Pattern p = Pattern.compile(pattern);
        ClientHandler foundClientHandler = null;
        try {
            Iterator iterator = this.findAllClient();
            while (iterator.hasNext()) {
                foundClientHandler = this.checkClientId((ClientHandler)iterator.next(), p);
                if (foundClientHandler == null) continue;
                list.add(foundClientHandler);
            }
        }
        catch (ConcurrentModificationException e) {
            if (callCount < 4) {
                list = null;
                return this.findAllClientById(pattern, ++callCount);
            }
            logger.finest("Going for backup..");
            return this.getBackupClientIdentifier().findAllClientById(pattern);
        }
        return list.iterator();
    }

    public ClientHandler findClientByKey(String key) {
        return this.findClientByKey(key, 0);
    }

    private ClientHandler findClientByKey(String key, int callCount) {
        ClientHandler foundClientHandler = null;
        try {
            Iterator iterator = this.findAllClient();
            while (iterator.hasNext() && (foundClientHandler = this.checkClientKey((ClientHandler)iterator.next(), key)) == null) {
            }
        }
        catch (ConcurrentModificationException e) {
            if (callCount < 4) {
                foundClientHandler = this.findClientByKey(key, ++callCount);
            }
            logger.finest("Going for backup..");
            foundClientHandler = this.getBackupClientIdentifier().findClientByKey(key);
        }
        return foundClientHandler;
    }

    public Iterator findAllClientByKey(String pattern) {
        return this.findAllClientByKey(pattern, 0);
    }

    private Iterator findAllClientByKey(String pattern, int callCount) {
        ArrayList<ClientHandler> list = new ArrayList<ClientHandler>();
        Pattern p = Pattern.compile(pattern);
        ClientHandler foundClientHandler = null;
        try {
            Iterator iterator = this.findAllClient();
            while (iterator.hasNext()) {
                foundClientHandler = this.checkClientKey((ClientHandler)iterator.next(), p);
                if (foundClientHandler != null) {
                    list.add(foundClientHandler);
                }
                foundClientHandler = null;
            }
        }
        catch (ConcurrentModificationException e) {
            if (callCount < 4) {
                list = null;
                return this.findAllClientByKey(pattern, ++callCount);
            }
            logger.finest("Going for backup..");
            return this.getBackupClientIdentifier().findAllClientByKey(pattern);
        }
        return list.iterator();
    }

    private synchronized ClientIdentifier getBackupClientIdentifier() {
        if (this.backupClientIdentifier == null) {
            this.backupClientIdentifier = new SyncClientIdentifier();
            this.backupClientIdentifier.setClientHandlerPool(this.clientHandlerPool);
        }
        return this.backupClientIdentifier;
    }
}

