/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.net.server.impl;

import java.util.Iterator;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.quickserver.net.server.ClientData;
import org.quickserver.net.server.ClientHandler;
import org.quickserver.net.server.ClientIdentifiable;
import org.quickserver.net.server.ClientIdentifier;
import org.quickserver.net.server.QuickServer;
import org.quickserver.util.pool.QSObjectPool;

public abstract class BasicClientIdentifier
implements ClientIdentifier {
    private static final Logger logger = Logger.getLogger(BasicClientIdentifier.class.getName());
    protected QSObjectPool clientHandlerPool;
    protected QuickServer quickserver;

    public void setQuickServer(QuickServer quickserver) {
        this.quickserver = quickserver;
    }

    public void setClientHandlerPool(QSObjectPool clientHandlerPool) {
        this.clientHandlerPool = clientHandlerPool;
    }

    public Object getObjectToSynchronize() {
        return this.clientHandlerPool.getObjectToSynchronize();
    }

    public Iterator findAllClient() {
        return this.clientHandlerPool.getAllActiveObjects();
    }

    protected ClientIdentifiable getClientIdentifiable(ClientHandler foundClientHandler) {
        if (foundClientHandler == null) {
            return null;
        }
        if (!foundClientHandler.isOpen()) {
            return null;
        }
        ClientData foundClientData = null;
        foundClientData = foundClientHandler.getClientData();
        if (foundClientData == null) {
            throw new IllegalStateException("No ClientData was set! Can't find a client with out it.");
        }
        if (!ClientIdentifiable.class.isInstance(foundClientData)) {
            throw new IllegalStateException("ClientData does not implement ClientIdentifiable! Can't find a client with out it.");
        }
        return (ClientIdentifiable)((Object)foundClientData);
    }

    protected ClientHandler checkClientId(ClientHandler foundClientHandler, String id) {
        ClientIdentifiable data = this.getClientIdentifiable(foundClientHandler);
        if (data == null) {
            return null;
        }
        String foundId = data.getClientId();
        if (foundId == null) {
            logger.finest("Id returned by ClientData was null! Client may not yet ready.. skipping");
            return null;
        }
        if (!foundId.equals(id)) {
            foundClientHandler = null;
        }
        return foundClientHandler;
    }

    protected ClientHandler checkClientId(ClientHandler foundClientHandler, Pattern pattern) {
        ClientIdentifiable data = this.getClientIdentifiable(foundClientHandler);
        if (data == null) {
            return null;
        }
        String foundId = data.getClientId();
        if (foundId == null) {
            logger.finest("Id returned by ClientData was null! Client may not yet ready.. skipping");
            return null;
        }
        Matcher m = pattern.matcher(foundId);
        if (!m.matches()) {
            foundClientHandler = null;
        }
        return foundClientHandler;
    }

    protected ClientHandler checkClientKey(ClientHandler foundClientHandler, String key) {
        ClientIdentifiable data = this.getClientIdentifiable(foundClientHandler);
        if (data == null) {
            return null;
        }
        String foundKey = data.getClientKey();
        if (foundKey == null) {
            logger.finest("Key returned by ClientData was null! Client may not yet ready.. skipping");
            return null;
        }
        if (!foundKey.equals(key)) {
            foundClientHandler = null;
        }
        return foundClientHandler;
    }

    protected ClientHandler checkClientKey(ClientHandler foundClientHandler, Pattern pattern) {
        ClientIdentifiable data = this.getClientIdentifiable(foundClientHandler);
        if (data == null) {
            return null;
        }
        String foundKey = data.getClientKey();
        if (foundKey == null) {
            logger.finest("Key returned by ClientData was null! Client may not yet ready.. skipping");
            return null;
        }
        Matcher m = pattern.matcher(foundKey);
        if (!m.matches()) {
            foundClientHandler = null;
        }
        return foundClientHandler;
    }
}

