/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.net.server;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quickserver.net.ServerHook;
import org.quickserver.net.server.ClientEvent;
import org.quickserver.net.server.ClientHandler;
import org.quickserver.net.server.ClientIdentifier;
import org.quickserver.net.server.QuickServer;
import org.quickserver.net.server.impl.BasicClientHandler;
import org.quickserver.net.server.impl.NonBlockingClientHandler;
import org.quickserver.util.Assertion;
import org.quickserver.util.MyString;

public class GhostSocketReaper
extends Thread
implements ServerHook {
    private static final Logger logger = Logger.getLogger(GhostSocketReaper.class.getName());
    private QuickServer quickserver;
    private volatile boolean stopFlag;
    private long timeOut = 0L;
    private long timeOutDelay = 0L;
    private ClientIdentifier clientIdentifier = null;

    public void initHook(QuickServer quickserver) {
        this.quickserver = quickserver;
        this.clientIdentifier = quickserver.getClientIdentifier();
    }

    public boolean handleEvent(int event) {
        if (event == 101) {
            this.setDaemon(true);
            this.stopFlag = false;
            this.setName("GhostSocketReaper-For-(" + this.quickserver + ")");
            this.start();
            return true;
        }
        if (event == 202) {
            this.stopFlag = true;
            return true;
        }
        return false;
    }

    public String info() {
        StringBuilder sb = new StringBuilder();
        sb.append("GhostSocketReaper - ServerHook");
        return sb.toString();
    }

    public void run() {
        logger.log(Level.FINE, "Starting GhostSocketReaper thread - {0}", this.quickserver.getName());
        if (this.quickserver.getTimeout() <= 0) {
            this.stopFlag = true;
            logger.log(Level.INFO, "Timeout is less than 0, so will exit - {0}", this.quickserver.getName());
            return;
        }
        this.timeOut = this.quickserver.getTimeout();
        if (this.quickserver.getBasicConfig().getServerMode().getBlocking()) {
            this.timeOutDelay = 1000L;
        }
        ArrayList ghostList = new ArrayList();
        long searchSleepTime = this.timeOut / 2L;
        int failCount = 0;
        boolean flag = false;
        while (!this.stopFlag) {
            try {
                try {
                    GhostSocketReaper.sleep(searchSleepTime);
                }
                catch (InterruptedException ie) {
                    logger.log(Level.WARNING, "InterruptedException : {0}", ie.getMessage());
                }
                if (failCount < 4) {
                    flag = this.optimisticGhostSocketsFinder(ghostList);
                    failCount = !flag ? ++failCount : 0;
                } else {
                    this.syncGhostSocketsFinder(ghostList);
                    failCount = 0;
                }
                this.cleanGhostSockets(ghostList, true);
            }
            catch (Exception e) {
                logger.fine("Exception : " + e);
                if (!Assertion.isEnabled()) continue;
                logger.finest("StackTrace:\n" + MyString.getStackTrace(e));
            }
        }
        while (this.stopFlag) {
            try {
                try {
                    GhostSocketReaper.sleep(searchSleepTime);
                }
                catch (InterruptedException ie) {
                    logger.warning("InterruptedException : " + ie.getMessage());
                }
                if (!this.quickserver.isClosed()) break;
                if (this.quickserver.getClientCount() > 0L) continue;
                try {
                    Thread.yield();
                    GhostSocketReaper.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    logger.warning("InterruptedException : " + ie.getMessage());
                }
                this.quickserver.closeAllPools();
                break;
            }
            catch (Exception e) {
                logger.fine("Exception : " + e);
                if (!Assertion.isEnabled()) break;
                logger.finest("StackTrace:\n" + MyString.getStackTrace(e));
                break;
            }
        }
        logger.log(Level.INFO, "Returning from GhostSocketReaper thread - {0}", this.quickserver.getName());
    }

    private long getCurrentTime() {
        return new Date().getTime();
    }

    private boolean optimisticGhostSocketsFinder(List list) {
        Iterator iterator = null;
        ClientHandler clientHandler = null;
        int count = 0;
        long currentTime = this.getCurrentTime();
        try {
            iterator = this.clientIdentifier.findAllClient();
            while (iterator.hasNext()) {
                if (++count == 60) {
                    currentTime = this.getCurrentTime();
                    count = 1;
                }
                clientHandler = (ClientHandler)iterator.next();
                this.checkClientHandlerForGhostSocket(clientHandler, currentTime, list);
                if (list.size() <= 100) continue;
                logger.fine("Found about 100 ghost sockets, lets clean..");
                break;
            }
        }
        catch (ConcurrentModificationException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncGhostSocketsFinder(List list) {
        Iterator iterator = null;
        ClientHandler clientHandler = null;
        int count = 0;
        long currentTime = this.getCurrentTime();
        Object object = this.clientIdentifier.getObjectToSynchronize();
        synchronized (object) {
            iterator = this.clientIdentifier.findAllClient();
            if (iterator.hasNext()) {
                logger.finest("ENTER");
            }
            while (iterator.hasNext()) {
                if (++count == 60) {
                    currentTime = this.getCurrentTime();
                    count = 1;
                }
                clientHandler = (ClientHandler)iterator.next();
                this.checkClientHandlerForGhostSocket(clientHandler, currentTime, list);
                if (list.size() <= 100) continue;
                logger.fine("Found about 100 ghost sockets, lets clean..");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanGhostSockets(List list, boolean checkTimeout) {
        long currentTime = this.getCurrentTime();
        long commTime = 0L;
        long diff = -1L;
        long closedCount = 0L;
        ClientHandler clientHandler = null;
        int size = list.size();
        if (size <= 0) {
            return;
        }
        logger.log(Level.INFO, "Found ghost sockets: {0}", size);
        for (int i = 0; i < size; ++i) {
            try {
                InputStream inputStream;
                InputStream obj;
                clientHandler = (ClientHandler)list.get(i);
                if (((BasicClientHandler)clientHandler).getWillClean()) {
                    logger.log(Level.FINEST, "Not closing client {0}, WillClean is true", clientHandler);
                    continue;
                }
                if (checkTimeout) {
                    this.timeOut = (long)clientHandler.getTimeout() + this.timeOutDelay;
                    if (clientHandler.getLastCommunicationTime() != null && (diff = currentTime - (commTime = clientHandler.getLastCommunicationTime().getTime())) < this.timeOut && !clientHandler.isClosed()) {
                        logger.log(Level.FINEST, "Not closing client {0}, must have been reassigned. CommTime(sec): {1}, Diff(sec): {2}", new Object[]{clientHandler, commTime / 1000L, diff / 1000L});
                        continue;
                    }
                }
                if (!clientHandler.isClosed()) {
                    logger.log(Level.FINEST, "Closing client {0}", clientHandler.getName());
                    ++closedCount;
                    try {
                        if (clientHandler.hasEvent(ClientEvent.RUN_BLOCKING)) {
                            clientHandler.closeConnection();
                            continue;
                        }
                        if (((NonBlockingClientHandler)clientHandler).getThreadAccessCount() != 0) {
                            clientHandler.closeConnection();
                            obj = clientHandler.getInputStream();
                            if (obj == null) continue;
                            inputStream = obj;
                            synchronized (inputStream) {
                                clientHandler.getInputStream().notifyAll();
                                continue;
                            }
                        }
                        clientHandler.addEvent(ClientEvent.CLOSE_CON);
                        this.quickserver.getClientPool().addClient(clientHandler);
                    }
                    catch (Exception er) {
                        logger.log(Level.FINE, "Error closing client {0} : {1}", new Object[]{clientHandler, er});
                        clientHandler.forceClose();
                    }
                    continue;
                }
                if (!clientHandler.hasEvent(ClientEvent.RUN_BLOCKING)) {
                    logger.log(Level.FINEST, "Notifying IO of client {0}", clientHandler);
                    obj = clientHandler.getInputStream();
                    if (obj == null) continue;
                    inputStream = obj;
                    synchronized (inputStream) {
                        clientHandler.getInputStream().notifyAll();
                    }
                    logger.log(Level.FINEST, "Returning objs to pool {0}", clientHandler);
                    if (this.quickserver.getClientDataPool() != null && clientHandler.getClientData() != null) {
                        this.quickserver.getClientDataPool().returnObject((Object)clientHandler.getClientData());
                    }
                    logger.log(Level.FINEST, "{0} returning {1}", new Object[]{Thread.currentThread().getName(), this.getName()});
                    this.quickserver.getClientHandlerPool().returnObject((Object)clientHandler);
                    continue;
                }
                logger.log(Level.FINEST, "Skipping closed {0} since in blocking mode.. this should clean up it self.", clientHandler);
                continue;
            }
            catch (Exception ee) {
                logger.log(Level.FINE, "Exception forcing the close : {0}", ee);
                if (!Assertion.isEnabled()) continue;
                logger.log(Level.FINEST, "StackTrace:\n{0}", MyString.getStackTrace(ee));
            }
        }
        logger.log(Level.INFO, "We closed : {0}", closedCount);
        list.clear();
    }

    private void checkClientHandlerForGhostSocket(ClientHandler clientHandler, long currentTime, List list) {
        long timeOutToUse;
        if (clientHandler == null) {
            return;
        }
        if (clientHandler.isClosed()) {
            logger.log(Level.FINEST, "Not connected .. so returning ClientData and ClientHandler objects for : {0}", clientHandler);
            list.add(clientHandler);
            return;
        }
        if (clientHandler.getTimeout() <= 0) {
            return;
        }
        if (clientHandler.getLastCommunicationTime() == null) {
            return;
        }
        long commTime = clientHandler.getLastCommunicationTime().getTime();
        long diff = currentTime - commTime;
        if (diff >= (timeOutToUse = (long)clientHandler.getTimeout() + this.timeOutDelay)) {
            logger.log(Level.FINE, "Closable client {0}, Time diff(sec) : {1}", new Object[]{clientHandler, diff / 1000L});
            list.add(clientHandler);
        }
    }
}

