/*
 * Decompiled with CFR 0.152.
 */
package org.quickserver.net.qsadmin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.logging.Logger;

public class QSAdminAPI {
    private static final Logger logger = Logger.getLogger(QSAdminAPI.class.getName());
    private String username = "Admin";
    private String password = "QsAdm1n";
    private String host = "localhost";
    private int port = 9877;
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private BufferedReader br;
    private BufferedWriter bw;

    public QSAdminAPI(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public boolean logon() throws IOException {
        return this.logon(this.username, this.password);
    }

    public boolean logon(String username, String password) throws IOException {
        this.username = username;
        this.password = password;
        logger.fine("Connecting to " + this.host + ":" + this.port);
        this.socket = new Socket(this.host, this.port);
        this.in = this.socket.getInputStream();
        this.out = this.socket.getOutputStream();
        this.br = new BufferedReader(new InputStreamReader(this.in, "UTF-8"));
        this.bw = new BufferedWriter(new OutputStreamWriter(this.out, "UTF-8"));
        logger.fine("Got : " + this.br.readLine());
        logger.fine("Got : " + this.br.readLine());
        logger.fine("Got : " + this.br.readLine());
        logger.fine("Got : " + this.br.readLine());
        logger.fine("Sending username");
        this.bw.write(username + "\r\n");
        this.bw.flush();
        logger.fine("Got : " + this.br.readLine());
        logger.fine("Sending password");
        this.bw.write(password + "\r\n");
        this.bw.flush();
        String temp = this.br.readLine();
        logger.fine("Got : " + temp);
        return temp.startsWith("+OK ");
    }

    public String sendCommand(String data) throws IOException {
        logger.fine("Sending command : " + data);
        this.bw.write(data + "\r\n");
        this.bw.flush();
        String temp = this.readResponse();
        logger.fine("Got : " + temp);
        return temp;
    }

    private String readResponse() throws IOException {
        StringBuilder command = new StringBuilder();
        String res = this.br.readLine();
        if (res != null && !res.equals("+OK info follows")) {
            return res;
        }
        while (res != null && !res.equals(".")) {
            command.append(res + "\r\n");
            res = this.br.readLine();
        }
        return command.toString();
    }

    public void logoff() throws IOException {
        logger.fine("Logging off");
        logger.fine("Sending command : quit");
        this.bw.write("quit\r\n");
        this.bw.flush();
        logger.fine("Got : " + this.br.readLine());
        this.close();
    }

    public void close() throws IOException {
        logger.fine("Closing");
        this.socket.close();
        this.socket = null;
    }

    public static void main(String[] args) throws Exception {
        QSAdminAPI qsAdminApi = new QSAdminAPI("127.0.0.1", 9080);
        if (qsAdminApi.logon()) {
            logger.info("Logged in");
            String info = qsAdminApi.sendCommand("info server");
            logger.info("Info on Server :\n" + info);
            qsAdminApi.logoff();
        } else {
            logger.warning("Bad Login!");
            qsAdminApi.close();
        }
    }
}

