/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectmapk.jackson.module.kogera.annotation_introspector;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.StdConverter;
import io.github.projectmapk.jackson.module.kogera.InternalCommonsKt;
import io.github.projectmapk.jackson.module.kogera.JmClass;
import io.github.projectmapk.jackson.module.kogera.ReflectionCache;
import io.github.projectmapk.jackson.module.kogera.ValueClassBoxConverter;
import io.github.projectmapk.jackson.module.kogera.ValueClassUnboxConverter;
import io.github.projectmapk.jackson.module.kogera.annotation.JsonKUnbox;
import io.github.projectmapk.jackson.module.kogera.annotation_introspector.KotlinFallbackAnnotationIntrospectorKt;
import io.github.projectmapk.jackson.module.kogera.ser.KotlinDurationValueToJavaDurationConverter;
import io.github.projectmapk.jackson.module.kogera.ser.KotlinToJavaDurationConverter;
import io.github.projectmapk.jackson.module.kogera.ser.SequenceToIteratorConverter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.time.Duration;
import kotlinx.metadata.KmFunction;
import kotlinx.metadata.KmProperty;
import kotlinx.metadata.KmType;
import kotlinx.metadata.KmValueParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\u001a\u0010\u0017\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\"\u0010\u001c\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\t\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\u001d2\u0006\u0010\n\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030 H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/github/projectmapk/jackson/module/kogera/annotation_introspector/KotlinFallbackAnnotationIntrospector;", "Lcom/fasterxml/jackson/databind/introspect/NopAnnotationIntrospector;", "strictNullChecks", "", "useJavaDurationConversion", "cache", "Lio/github/projectmapk/jackson/module/kogera/ReflectionCache;", "(ZZLio/github/projectmapk/jackson/module/kogera/ReflectionCache;)V", "findDeserializationConverter", "", "a", "Lcom/fasterxml/jackson/databind/introspect/Annotated;", "findImplicitPropertyName", "", "member", "Lcom/fasterxml/jackson/databind/introspect/AnnotatedMember;", "findKotlinParameter", "Lkotlinx/metadata/KmValueParameter;", "param", "Lcom/fasterxml/jackson/databind/introspect/AnnotatedParameter;", "findNullSerializer", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "am", "findSerializationConverter", "Lcom/fasterxml/jackson/databind/util/Converter;", "findSetterInfo", "Lcom/fasterxml/jackson/annotation/JsonSetter$Value;", "ann", "lookupKotlinTypeConverter", "Lcom/fasterxml/jackson/databind/util/StdConverter;", "Lcom/fasterxml/jackson/databind/introspect/AnnotatedClass;", "requireRebox", "Ljava/lang/Class;", "jackson-module-kogera"})
public final class KotlinFallbackAnnotationIntrospector
extends NopAnnotationIntrospector {
    private final boolean strictNullChecks;
    private final boolean useJavaDurationConversion;
    @NotNull
    private final ReflectionCache cache;

    public KotlinFallbackAnnotationIntrospector(boolean strictNullChecks, boolean useJavaDurationConversion, @NotNull ReflectionCache cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.strictNullChecks = strictNullChecks;
        this.useJavaDurationConversion = useJavaDurationConversion;
        this.cache = cache;
    }

    private final KmValueParameter findKotlinParameter(AnnotatedParameter param) {
        KmValueParameter kmValueParameter;
        List list;
        List list2;
        Member owner = param.getOwner().getMember();
        if (owner instanceof Constructor) {
            Class clazz = param.getDeclaringClass();
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"param.declaringClass");
            JmClass jmClass = this.cache.getJmClass(clazz);
            list2 = jmClass != null && (jmClass = jmClass.findKmConstructor((Constructor)owner)) != null ? jmClass.getValueParameters() : null;
        } else if (owner instanceof Method) {
            if (Modifier.isStatic(((Method)owner).getModifiers())) {
                JmClass.CompanionObject companionObject;
                Class clazz = param.getDeclaringClass();
                Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"param.declaringClass");
                JmClass jmClass = this.cache.getJmClass(clazz);
                if (jmClass != null && (companionObject = jmClass.getCompanion()) != null) {
                    JmClass.CompanionObject it = companionObject;
                    boolean bl = false;
                    KmFunction kmFunction = it.findFunctionByMethod((Method)owner);
                    list2 = kmFunction != null ? kmFunction.getValueParameters() : null;
                } else {
                    list2 = null;
                }
            } else {
                list2 = null;
            }
        } else {
            list2 = list = null;
        }
        if (list != null) {
            List it = list;
            boolean bl = false;
            kmValueParameter = (KmValueParameter)it.get(param.getIndex());
        } else {
            kmValueParameter = null;
        }
        return kmValueParameter;
    }

    private final KmValueParameter findKotlinParameter(Annotated param) {
        KmValueParameter kmValueParameter;
        AnnotatedParameter annotatedParameter = param instanceof AnnotatedParameter ? (AnnotatedParameter)param : null;
        if (annotatedParameter != null) {
            AnnotatedParameter it = annotatedParameter;
            boolean bl = false;
            kmValueParameter = this.findKotlinParameter(it);
        } else {
            kmValueParameter = null;
        }
        return kmValueParameter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public String findImplicitPropertyName(@NotNull AnnotatedMember member) {
        String string;
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        AnnotatedMember annotatedMember = member;
        if (annotatedMember instanceof AnnotatedMethod) {
            if (((AnnotatedMethod)member).getParameterCount() != 0) return null;
            Class clazz = ((AnnotatedMethod)member).getDeclaringClass();
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"member.declaringClass");
            JmClass jmClass = this.cache.getJmClass(clazz);
            JmClass jmClass2 = jmClass;
            if (jmClass == null) return null;
            Method method = ((AnnotatedMethod)member).getAnnotated();
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"member.annotated");
            KmProperty kmProperty = jmClass2.findPropertyByGetter(method);
            jmClass2 = kmProperty;
            if (kmProperty == null) return null;
            string = jmClass2.getName();
            return string;
        } else {
            if (!(annotatedMember instanceof AnnotatedParameter)) return null;
            KmValueParameter kmValueParameter = this.findKotlinParameter((AnnotatedParameter)member);
            if (kmValueParameter == null) return null;
            string = kmValueParameter.getName();
        }
        return string;
    }

    @Nullable
    public Object findDeserializationConverter(@NotNull Annotated a) {
        ValueClassUnboxConverter valueClassUnboxConverter;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        KmValueParameter kmValueParameter = this.findKotlinParameter(a);
        if (kmValueParameter != null) {
            Class clazz = a.getRawType();
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"a.rawType");
            valueClassUnboxConverter = KotlinFallbackAnnotationIntrospectorKt.access$createValueClassUnboxConverterOrNull(kmValueParameter, clazz);
        } else {
            valueClassUnboxConverter = null;
        }
        return valueClassUnboxConverter;
    }

    @Nullable
    public Converter<?, ?> findSerializationConverter(@NotNull Annotated a) {
        Converter converter;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Annotated annotated = a;
        if (annotated instanceof AnnotatedMethod) {
            StdConverter stdConverter;
            Method method = ((AnnotatedMethod)a).getMember();
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"a.member");
            Class<?> clazz = this.cache.findBoxedReturnType(method);
            if (clazz != null) {
                Class<?> it = clazz;
                boolean bl = false;
                if (this.useJavaDurationConversion && Intrinsics.areEqual(it, Duration.class)) {
                    stdConverter = Intrinsics.areEqual((Object)((AnnotatedMethod)a).getRawReturnType(), Duration.class) ? (StdConverter)KotlinToJavaDurationConverter.INSTANCE : (StdConverter)KotlinDurationValueToJavaDurationConverter.INSTANCE;
                } else {
                    ValueClassBoxConverter<?, ?> valueClassBoxConverter;
                    if (a.hasAnnotation(JsonKUnbox.class) || it.getAnnotation(JsonKUnbox.class) != null) {
                        valueClassBoxConverter = null;
                    } else {
                        Class clazz2 = ((AnnotatedMethod)a).getRawReturnType();
                        Intrinsics.checkNotNullExpressionValue((Object)clazz2, (String)"a.rawReturnType");
                        valueClassBoxConverter = this.cache.getValueClassBoxConverter(clazz2, it);
                    }
                    stdConverter = valueClassBoxConverter;
                }
            } else {
                stdConverter = null;
            }
            converter = (Converter)stdConverter;
        } else {
            converter = annotated instanceof AnnotatedClass ? (Converter)this.lookupKotlinTypeConverter((AnnotatedClass)a) : null;
        }
        return converter;
    }

    private final StdConverter<? extends Object, ? extends Object> lookupKotlinTypeConverter(AnnotatedClass a) {
        StdConverter stdConverter;
        if (Sequence.class.isAssignableFrom(a.getRawType())) {
            JavaType javaType = a.getType();
            Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"a.type");
            stdConverter = new SequenceToIteratorConverter(javaType);
        } else if (Intrinsics.areEqual(Duration.class, (Object)a.getRawType())) {
            KotlinToJavaDurationConverter kotlinToJavaDurationConverter;
            KotlinToJavaDurationConverter it = kotlinToJavaDurationConverter = KotlinToJavaDurationConverter.INSTANCE;
            boolean bl = false;
            stdConverter = this.useJavaDurationConversion ? kotlinToJavaDurationConverter : null;
        } else {
            stdConverter = null;
        }
        return stdConverter;
    }

    private final boolean requireRebox(Class<?> $this$requireRebox) {
        JmClass jmClass = this.cache.getJmClass($this$requireRebox);
        Intrinsics.checkNotNull((Object)jmClass);
        KmType kmType = jmClass.getInlineClassUnderlyingType();
        Intrinsics.checkNotNull((Object)kmType);
        return InternalCommonsKt.isNullable(kmType);
    }

    @Nullable
    public JsonSerializer<?> findNullSerializer(@NotNull Annotated am) {
        StdDelegatingSerializer stdDelegatingSerializer;
        Intrinsics.checkNotNullParameter((Object)am, (String)"am");
        if ((am instanceof AnnotatedMethod ? (AnnotatedMethod)am : null) != null) {
            boolean bl = false;
            Method method = ((AnnotatedMethod)am).getMember();
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"am.member");
            Class<?> clazz = this.cache.findBoxedReturnType(method);
            if (clazz != null) {
                Class<?> it = clazz;
                boolean bl2 = false;
                if (this.requireRebox(it)) {
                    Class clazz2 = ((AnnotatedMethod)am).getRawReturnType();
                    Intrinsics.checkNotNullExpressionValue((Object)clazz2, (String)"am.rawReturnType");
                    stdDelegatingSerializer = this.cache.getValueClassBoxConverter(clazz2, it).getDelegatingSerializer();
                } else {
                    stdDelegatingSerializer = null;
                }
            } else {
                stdDelegatingSerializer = null;
            }
        } else {
            stdDelegatingSerializer = null;
        }
        return (JsonSerializer)stdDelegatingSerializer;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public JsonSetter.Value findSetterInfo(@NotNull Annotated ann) {
        JsonSetter.Value value;
        Annotated annotated;
        Annotated annotated2;
        Intrinsics.checkNotNullParameter((Object)ann, (String)"ann");
        Annotated it = annotated2 = ann;
        boolean bl = false;
        Object object = annotated = this.strictNullChecks ? annotated2 : null;
        if (annotated != null) {
            JsonSetter.Value value2;
            boolean bl2 = false;
            KmValueParameter kmValueParameter = this.findKotlinParameter(ann);
            if (kmValueParameter != null) {
                KmValueParameter valueParameter = kmValueParameter;
                boolean bl3 = false;
                JavaType javaType = ann.getType();
                Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"ann.type");
                value2 = KotlinFallbackAnnotationIntrospectorKt.access$requireStrictNullCheck(valueParameter, javaType) ? JsonSetter.Value.forContentNulls((Nulls)Nulls.FAIL) : null;
            } else {
                value2 = null;
            }
            if ((annotated2 = value2) != null) {
                value = annotated2;
                return value;
            }
        }
        JsonSetter.Value value = super.findSetterInfo(ann);
        value = value;
        Intrinsics.checkNotNullExpressionValue((Object)value3, (String)"super.findSetterInfo(ann)");
        return value;
    }
}

