/*
 * Decompiled with CFR 0.152.
 */
package com.pierfrancescosoffritti.youtubeplayer.player.playerUtils;

import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.pierfrancescosoffritti.youtubeplayer.player.YouTubePlayerFullScreenListener;
import java.util.HashSet;
import java.util.Set;

public class FullScreenHelper {
    private boolean isFullScreen = false;
    private final Set<YouTubePlayerFullScreenListener> fullScreenListeners = new HashSet<YouTubePlayerFullScreenListener>();

    public void enterFullScreen(@NonNull View view) {
        if (this.isFullScreen) {
            return;
        }
        ViewGroup.LayoutParams viewParams = view.getLayoutParams();
        viewParams.height = -1;
        viewParams.width = -1;
        view.setLayoutParams(viewParams);
        this.isFullScreen = true;
        for (YouTubePlayerFullScreenListener fullScreenListener : this.fullScreenListeners) {
            fullScreenListener.onYouTubePlayerEnterFullScreen();
        }
    }

    public void exitFullScreen(@NonNull View view) {
        if (!this.isFullScreen) {
            return;
        }
        ViewGroup.LayoutParams viewParams = view.getLayoutParams();
        viewParams.height = -2;
        viewParams.width = -1;
        view.setLayoutParams(viewParams);
        this.isFullScreen = false;
        for (YouTubePlayerFullScreenListener fullScreenListener : this.fullScreenListeners) {
            fullScreenListener.onYouTubePlayerExitFullScreen();
        }
    }

    public void toggleFullScreen(@NonNull View view) {
        if (this.isFullScreen) {
            this.exitFullScreen(view);
        } else {
            this.enterFullScreen(view);
        }
    }

    public boolean isFullScreen() {
        return this.isFullScreen;
    }

    public boolean addFullScreenListener(@NonNull YouTubePlayerFullScreenListener fullScreenListener) {
        return this.fullScreenListeners.add(fullScreenListener);
    }

    public boolean removeFullScreenListener(@NonNull YouTubePlayerFullScreenListener fullScreenListener) {
        return this.fullScreenListeners.remove(fullScreenListener);
    }
}

