/*
 * Decompiled with CFR 0.152.
 */
package com.pierfrancescosoffritti.youtubeplayer.ui.menu.defaultMenu;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;
import com.pierfrancescosoffritti.youtubeplayer.R;
import com.pierfrancescosoffritti.youtubeplayer.ui.menu.MenuItem;
import com.pierfrancescosoffritti.youtubeplayer.ui.menu.YouTubePlayerMenu;
import com.pierfrancescosoffritti.youtubeplayer.ui.menu.defaultMenu.MenuAdapter;
import java.util.ArrayList;
import java.util.List;

public class DefaultYouTubePlayerMenu
implements YouTubePlayerMenu {
    private final Context context;
    private final List<MenuItem> menuItems;
    @Nullable
    private PopupWindow popupWindow;

    public DefaultYouTubePlayerMenu(@NonNull Context context) {
        this.context = context;
        this.menuItems = new ArrayList<MenuItem>();
    }

    @Override
    public void show(View anchorView) {
        this.popupWindow = this.createPopupWindow();
        this.popupWindow.showAsDropDown(anchorView, 0, -this.context.getResources().getDimensionPixelSize(R.dimen._8dp) * 4);
        if (this.menuItems.size() == 0) {
            Log.e((String)YouTubePlayerMenu.class.getName(), (String)"The menu is empty");
        }
    }

    @Override
    public void dismiss() {
        if (this.popupWindow != null) {
            this.popupWindow.dismiss();
        }
    }

    @Override
    public void addItem(MenuItem menuItem) {
        this.menuItems.add(menuItem);
    }

    @Override
    public void removeItem(int itemIndex) {
        this.menuItems.remove(itemIndex);
    }

    @Override
    public int getItemCount() {
        return this.menuItems.size();
    }

    @NonNull
    private PopupWindow createPopupWindow() {
        LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        if (inflater == null) {
            throw new RuntimeException("can't access LAYOUT_INFLATER_SERVICE");
        }
        View view = inflater.inflate(R.layout.player_menu, null);
        RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.recycler_view);
        this.setUpRecyclerView(recyclerView);
        PopupWindow popupWindow = new PopupWindow(view, -2, -2);
        popupWindow.setFocusable(true);
        popupWindow.setWidth(-2);
        popupWindow.setHeight(-2);
        popupWindow.setContentView(view);
        return popupWindow;
    }

    private void setUpRecyclerView(RecyclerView recyclerView) {
        recyclerView.setHasFixedSize(true);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.context));
        MenuAdapter adapter = new MenuAdapter(this.context, this.menuItems);
        recyclerView.setAdapter((RecyclerView.Adapter)adapter);
    }
}

