/*
 * Decompiled with CFR 0.152.
 */
package com.pierfrancescosoffritti.youtubeplayer.player;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.webkit.JavascriptInterface;
import com.pierfrancescosoffritti.youtubeplayer.player.WebViewYouTubePlayer;
import com.pierfrancescosoffritti.youtubeplayer.player.YouTubePlayerListener;

public class YouTubePlayerBridge {
    private static final String STATE_UNSTARTED = "UNSTARTED";
    private static final String STATE_ENDED = "ENDED";
    private static final String STATE_PLAYING = "PLAYING";
    private static final String STATE_PAUSED = "PAUSED";
    private static final String STATE_BUFFERING = "BUFFERING";
    private static final String STATE_CUED = "CUED";
    private static final String QUALITY_SMALL = "small";
    private static final String QUALITY_MEDIUM = "medium";
    private static final String QUALITY_LARGE = "large";
    private static final String QUALITY_HD720 = "hd720";
    private static final String QUALITY_HD1080 = "hd1080";
    private static final String QUALITY_HIGH_RES = "highres";
    private static final String QUALITY_DEFAULT = "default";
    private static final String RATE_0_25 = "0.25";
    private static final String RATE_0_5 = "0.5";
    private static final String RATE_1 = "1";
    private static final String RATE_1_5 = "1.5";
    private static final String RATE_2 = "2";
    private static final String ERROR_INVALID_PARAMETER_IN_REQUEST = "2";
    private static final String ERROR_HTML_5_PLAYER = "5";
    private static final String ERROR_VIDEO_NOT_FOUND = "100";
    private static final String ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER1 = "101";
    private static final String ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER2 = "150";
    @NonNull
    private final WebViewYouTubePlayer youTubePlayer;
    @NonNull
    private final Handler mainThreadHandler;

    public YouTubePlayerBridge(@NonNull WebViewYouTubePlayer youTubePlayer) {
        this.youTubePlayer = youTubePlayer;
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
    }

    @JavascriptInterface
    public void sendYouTubeIframeAPIReady() {
        this.youTubePlayer.onYouTubeIframeAPIReady();
    }

    @JavascriptInterface
    public void sendReady() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayerListener listener : YouTubePlayerBridge.this.youTubePlayer.getListeners()) {
                    listener.onReady();
                }
            }
        });
    }

    @JavascriptInterface
    public void sendStateChange(String state) {
        final int playerState = this.parsePlayerState(state);
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayerListener listener : YouTubePlayerBridge.this.youTubePlayer.getListeners()) {
                    listener.onStateChange(playerState);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendPlaybackQualityChange(String quality) {
        final int playbackQuality = this.parsePlaybackQuality(quality);
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayerListener listener : YouTubePlayerBridge.this.youTubePlayer.getListeners()) {
                    listener.onPlaybackQualityChange(playbackQuality);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendPlaybackRateChange(String rate) {
        final String playbackRate = this.parsePlaybackRate(rate);
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayerListener listener : YouTubePlayerBridge.this.youTubePlayer.getListeners()) {
                    listener.onPlaybackRateChange(playbackRate);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendError(String error) {
        final int playerError = this.parsePlayerError(error);
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayerListener listener : YouTubePlayerBridge.this.youTubePlayer.getListeners()) {
                    listener.onError(playerError);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendApiChange() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayerListener listener : YouTubePlayerBridge.this.youTubePlayer.getListeners()) {
                    listener.onApiChange();
                }
            }
        });
    }

    @JavascriptInterface
    public void sendVideoCurrentTime(String seconds) {
        float currentTimeSeconds;
        try {
            currentTimeSeconds = Float.parseFloat(seconds);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return;
        }
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayerListener listener : YouTubePlayerBridge.this.youTubePlayer.getListeners()) {
                    listener.onCurrentSecond(currentTimeSeconds);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendVideoDuration(String seconds) {
        float videoDuration;
        try {
            String finalSeconds = TextUtils.isEmpty((CharSequence)seconds) ? "0" : seconds;
            videoDuration = Float.parseFloat(finalSeconds);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return;
        }
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayerListener listener : YouTubePlayerBridge.this.youTubePlayer.getListeners()) {
                    listener.onVideoDuration(videoDuration);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendVideoId(final String videoId) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayerListener listener : YouTubePlayerBridge.this.youTubePlayer.getListeners()) {
                    listener.onVideoId(videoId);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendMessage(final String message) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayerListener listener : YouTubePlayerBridge.this.youTubePlayer.getListeners()) {
                    listener.onMessage(message);
                }
            }
        });
    }

    private int parsePlayerState(String state) {
        int playerState = state.equalsIgnoreCase(STATE_UNSTARTED) ? -1 : (state.equalsIgnoreCase(STATE_ENDED) ? 0 : (state.equalsIgnoreCase(STATE_PLAYING) ? 1 : (state.equalsIgnoreCase(STATE_PAUSED) ? 2 : (state.equalsIgnoreCase(STATE_BUFFERING) ? 3 : (state.equalsIgnoreCase(STATE_CUED) ? 5 : -10)))));
        return playerState;
    }

    private int parsePlaybackQuality(String quality) {
        int playbackQuality = quality.equalsIgnoreCase(QUALITY_SMALL) ? 0 : (quality.equalsIgnoreCase(QUALITY_MEDIUM) ? 1 : (quality.equalsIgnoreCase(QUALITY_LARGE) ? 2 : (quality.equalsIgnoreCase(QUALITY_HD720) ? 3 : (quality.equalsIgnoreCase(QUALITY_HD1080) ? 4 : (quality.equalsIgnoreCase(QUALITY_HIGH_RES) ? 5 : (quality.equalsIgnoreCase(QUALITY_DEFAULT) ? -1 : -10))))));
        return playbackQuality;
    }

    private String parsePlaybackRate(String rate) {
        String playbackRate = rate.equalsIgnoreCase(RATE_0_25) ? RATE_0_25 : (rate.equalsIgnoreCase(RATE_0_5) ? RATE_0_5 : (rate.equalsIgnoreCase(RATE_1) ? RATE_1 : (rate.equalsIgnoreCase(RATE_1_5) ? RATE_1_5 : (rate.equalsIgnoreCase("2") ? "2" : "-10"))));
        return playbackRate;
    }

    private int parsePlayerError(String error) {
        int playerError = error.equalsIgnoreCase("2") ? 0 : (error.equalsIgnoreCase(ERROR_HTML_5_PLAYER) ? 1 : (error.equalsIgnoreCase(ERROR_VIDEO_NOT_FOUND) ? 2 : (error.equalsIgnoreCase(ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER1) ? 3 : (error.equalsIgnoreCase(ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER2) ? 3 : -10))));
        return playerError;
    }
}

