/*
 * Decompiled with CFR 0.152.
 */
package com.pierfrancescosoffritti.youtubeplayer.player;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.pierfrancescosoffritti.youtubeplayer.R;
import com.pierfrancescosoffritti.youtubeplayer.player.AbstractYouTubePlayerListener;
import com.pierfrancescosoffritti.youtubeplayer.player.YouTubePlayer;
import com.pierfrancescosoffritti.youtubeplayer.player.YouTubePlayerBridge;
import com.pierfrancescosoffritti.youtubeplayer.player.YouTubePlayerInitListener;
import com.pierfrancescosoffritti.youtubeplayer.player.YouTubePlayerListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;

class WebViewYouTubePlayer
extends WebView
implements YouTubePlayer {
    @NonNull
    private final Set<YouTubePlayerListener> youTubePlayerListeners;
    @NonNull
    private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private YouTubePlayerInitListener youTubePlayerInitListener;
    @Nullable
    private PlayerStateTracker playerStateTracker;

    protected WebViewYouTubePlayer(Context context) {
        this(context, null);
    }

    protected WebViewYouTubePlayer(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    protected WebViewYouTubePlayer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.youTubePlayerListeners = new HashSet<YouTubePlayerListener>();
    }

    protected void initialize(@NonNull YouTubePlayerInitListener initListener) {
        this.youTubePlayerListeners.clear();
        this.youTubePlayerInitListener = initListener;
        this.playerStateTracker = new PlayerStateTracker();
        this.youTubePlayerListeners.add(this.playerStateTracker);
        this.initWebView();
    }

    protected void onYouTubeIframeAPIReady() {
        this.youTubePlayerInitListener.onInitSuccess(this);
    }

    @Override
    public void loadVideo(final String videoId, final float startSeconds) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewYouTubePlayer.this.loadUrl("javascript:loadVideo('" + videoId + "', " + startSeconds + ")");
            }
        });
    }

    @Override
    public void cueVideo(final String videoId, final float startSeconds) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewYouTubePlayer.this.loadUrl("javascript:cueVideo('" + videoId + "', " + startSeconds + ")");
            }
        });
    }

    @Override
    public void play() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewYouTubePlayer.this.loadUrl("javascript:playVideo()");
            }
        });
    }

    @Override
    public void pause() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewYouTubePlayer.this.loadUrl("javascript:pauseVideo()");
            }
        });
    }

    @Override
    public void mute() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewYouTubePlayer.this.loadUrl("javascript:mute()");
            }
        });
    }

    @Override
    public void unMute() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewYouTubePlayer.this.loadUrl("javascript:unMute()");
            }
        });
    }

    @Override
    public void seekTo(final int time) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                WebViewYouTubePlayer.this.loadUrl("javascript:seekTo(" + time + ")");
            }
        });
    }

    @Override
    public int getCurrentState() {
        if (this.playerStateTracker == null) {
            throw new RuntimeException("Player not initialized.");
        }
        return this.playerStateTracker.currentState;
    }

    public void destroy() {
        this.mainThreadHandler.removeCallbacksAndMessages(null);
        super.destroy();
    }

    @NonNull
    protected Set<YouTubePlayerListener> getListeners() {
        return this.youTubePlayerListeners;
    }

    @Override
    public boolean addListener(YouTubePlayerListener listener) {
        return this.youTubePlayerListeners.add(listener);
    }

    @Override
    public boolean removeListener(YouTubePlayerListener listener) {
        return this.youTubePlayerListeners.remove(listener);
    }

    private void initWebView() {
        WebSettings settings = this.getSettings();
        settings.setJavaScriptEnabled(true);
        settings.setCacheMode(2);
        settings.setMediaPlaybackRequiresUserGesture(false);
        this.addJavascriptInterface(new YouTubePlayerBridge(this), "YouTubePlayerBridge");
        this.loadDataWithBaseURL("https://www.youtube.com", this.readYouTubePlayerHTMLFromFile(), "text/html", "utf-8", null);
    }

    private String readYouTubePlayerHTMLFromFile() {
        try {
            String read;
            InputStream inputStream = this.getResources().openRawResource(R.raw.youtube_player);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder sb = new StringBuilder();
            while ((read = bufferedReader.readLine()) != null) {
                sb.append(read).append("\n");
            }
            inputStream.close();
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't parse HTML file containing the player.");
        }
    }

    private class PlayerStateTracker
    extends AbstractYouTubePlayerListener {
        private int currentState;

        private PlayerStateTracker() {
        }

        @Override
        public void onStateChange(int state) {
            this.currentState = state;
        }
    }
}

