/*
 * Decompiled with CFR 0.152.
 */
package com.pierfrancescosoffritti.youtubeplayer;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.webkit.JavascriptInterface;
import com.pierfrancescosoffritti.youtubeplayer.YouTubePlayer;

public class YouTubePlayerBridge {
    @NonNull
    private final YouTubePlayer youTubePlayer;
    @NonNull
    private final Handler mainThreadHandler;

    public YouTubePlayerBridge(@NonNull YouTubePlayer youTubePlayer) {
        this.youTubePlayer = youTubePlayer;
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
    }

    @JavascriptInterface
    public void onReady() {
        for (YouTubePlayer.YouTubeListener listener : this.youTubePlayer.getListeners()) {
            listener.onReady();
        }
    }

    @JavascriptInterface
    public void onStateChange(final String state) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayer.YouTubeListener listener : YouTubePlayerBridge.this.youTubePlayer.getListeners()) {
                    if ("UNSTARTED".equalsIgnoreCase(state)) {
                        listener.onStateChange(-1);
                        continue;
                    }
                    if ("ENDED".equalsIgnoreCase(state)) {
                        listener.onStateChange(0);
                        continue;
                    }
                    if ("PLAYING".equalsIgnoreCase(state)) {
                        listener.onStateChange(1);
                        continue;
                    }
                    if ("PAUSED".equalsIgnoreCase(state)) {
                        listener.onStateChange(2);
                        continue;
                    }
                    if ("BUFFERING".equalsIgnoreCase(state)) {
                        listener.onStateChange(3);
                        continue;
                    }
                    if (!"CUED".equalsIgnoreCase(state)) continue;
                    listener.onStateChange(5);
                }
            }
        });
    }

    @JavascriptInterface
    public void onPlaybackQualityChange(final String quality) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayer.YouTubeListener listener : YouTubePlayerBridge.this.youTubePlayer.getListeners()) {
                    if ("small".equalsIgnoreCase(quality)) {
                        listener.onPlaybackQualityChange(0);
                        continue;
                    }
                    if ("medium".equalsIgnoreCase(quality)) {
                        listener.onPlaybackQualityChange(1);
                        continue;
                    }
                    if ("large".equalsIgnoreCase(quality)) {
                        listener.onPlaybackQualityChange(2);
                        continue;
                    }
                    if ("hd720".equalsIgnoreCase(quality)) {
                        listener.onPlaybackQualityChange(3);
                        continue;
                    }
                    if ("hd1080".equalsIgnoreCase(quality)) {
                        listener.onPlaybackQualityChange(4);
                        continue;
                    }
                    if ("highres".equalsIgnoreCase(quality)) {
                        listener.onPlaybackQualityChange(5);
                        continue;
                    }
                    if (!"default".equalsIgnoreCase(quality)) continue;
                    listener.onPlaybackQualityChange(-1);
                }
            }
        });
    }

    @JavascriptInterface
    public void onPlaybackRateChange(final String rate) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    double dRate = Double.parseDouble(rate);
                    for (YouTubePlayer.YouTubeListener listener : YouTubePlayerBridge.this.youTubePlayer.getListeners()) {
                        listener.onPlaybackRateChange(dRate);
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @JavascriptInterface
    public void onError(final String error) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayer.YouTubeListener listener : YouTubePlayerBridge.this.youTubePlayer.getListeners()) {
                    if ("2".equalsIgnoreCase(error)) {
                        listener.onError(0);
                        continue;
                    }
                    if ("5".equalsIgnoreCase(error)) {
                        listener.onError(1);
                        continue;
                    }
                    if ("100".equalsIgnoreCase(error)) {
                        listener.onError(2);
                        continue;
                    }
                    if ("101".equalsIgnoreCase(error)) {
                        listener.onError(3);
                        continue;
                    }
                    if (!"150".equalsIgnoreCase(error)) continue;
                    listener.onError(3);
                }
            }
        });
    }

    @JavascriptInterface
    public void onApiChange() {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayer.YouTubeListener listener : YouTubePlayerBridge.this.youTubePlayer.getListeners()) {
                    listener.onApiChange();
                }
            }
        });
    }

    @JavascriptInterface
    public void currentSeconds(String seconds) {
        float fSeconds;
        try {
            fSeconds = Float.parseFloat(seconds);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return;
        }
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayer.YouTubeListener listener : YouTubePlayerBridge.this.youTubePlayer.getListeners()) {
                    listener.onCurrentSecond(fSeconds);
                }
            }
        });
    }

    @JavascriptInterface
    public void onVideoTitle(final String videoTitle) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayer.YouTubeListener listener : YouTubePlayerBridge.this.youTubePlayer.getListeners()) {
                    listener.onVideoTitle(videoTitle);
                }
            }
        });
    }

    @JavascriptInterface
    public void onVideoId(final String videoId) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayer.YouTubeListener listener : YouTubePlayerBridge.this.youTubePlayer.getListeners()) {
                    listener.onVideoId(videoId);
                }
            }
        });
    }

    @JavascriptInterface
    public void onVideoDuration(final String seconds) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    float videoDuration = Float.parseFloat(seconds);
                    for (YouTubePlayer.YouTubeListener listener : YouTubePlayerBridge.this.youTubePlayer.getListeners()) {
                        listener.onVideoDuration(videoDuration);
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @JavascriptInterface
    public void onLog(final String message) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayer.YouTubeListener listener : YouTubePlayerBridge.this.youTubePlayer.getListeners()) {
                    listener.onLog(message);
                }
            }
        });
    }
}

