/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.animation.ValueAnimator;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.RequiresApi;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.animation.Easing;
import com.github.mikephil.charting.components.Description;
import com.github.mikephil.charting.components.IMarker;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.formatter.DefaultValueFormatter;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.highlight.ChartHighlighter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.highlight.IHighlighter;
import com.github.mikephil.charting.interfaces.dataprovider.ChartInterface;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.listener.ChartTouchListener;
import com.github.mikephil.charting.listener.OnChartGestureListener;
import com.github.mikephil.charting.listener.OnChartValueSelectedListener;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.renderer.LegendRenderer;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public abstract class Chart<T extends ChartData<? extends IDataSet<? extends Entry>>>
extends ViewGroup
implements ChartInterface {
    public static final String LOG_TAG = "MPAndroidChart";
    protected boolean mLogEnabled = false;
    protected T mData = null;
    protected boolean mHighLightPerTapEnabled = true;
    private boolean mDragDecelerationEnabled = true;
    private float mDragDecelerationFrictionCoef = 0.9f;
    protected DefaultValueFormatter mDefaultValueFormatter = new DefaultValueFormatter(0);
    protected Paint mDescPaint;
    protected Paint mInfoPaint;
    protected XAxis mXAxis;
    protected boolean mTouchEnabled = true;
    protected Description mDescription;
    protected Legend mLegend;
    protected OnChartValueSelectedListener mSelectionListener;
    protected ChartTouchListener mChartTouchListener;
    private String mNoDataText = "No chart data available.";
    private OnChartGestureListener mGestureListener;
    protected LegendRenderer mLegendRenderer;
    protected DataRenderer mRenderer;
    protected IHighlighter mHighlighter;
    protected ViewPortHandler mViewPortHandler = new ViewPortHandler();
    protected ChartAnimator mAnimator;
    private float mExtraTopOffset = 0.0f;
    private float mExtraRightOffset = 0.0f;
    private float mExtraBottomOffset = 0.0f;
    private float mExtraLeftOffset = 0.0f;
    private boolean mOffsetsCalculated = false;
    protected Highlight[] mIndicesToHighlight;
    protected float mMaxHighlightDistance = 0.0f;
    protected boolean mDrawMarkers = true;
    protected IMarker mMarker;
    public static final int PAINT_GRID_BACKGROUND = 4;
    public static final int PAINT_INFO = 7;
    public static final int PAINT_DESCRIPTION = 11;
    public static final int PAINT_HOLE = 13;
    public static final int PAINT_CENTER_TEXT = 14;
    public static final int PAINT_LEGEND_LABEL = 18;
    protected ArrayList<Runnable> mJobs = new ArrayList();
    private boolean mUnbind = false;

    public Chart(Context context) {
        super(context);
        this.init();
    }

    public Chart(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public Chart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    protected void init() {
        this.setWillNotDraw(false);
        this.mAnimator = Build.VERSION.SDK_INT < 11 ? new ChartAnimator() : new ChartAnimator(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Chart.this.postInvalidate();
            }
        });
        Utils.init(this.getContext());
        this.mMaxHighlightDistance = Utils.convertDpToPixel(500.0f);
        this.mDescription = new Description();
        this.mLegend = new Legend();
        this.mLegendRenderer = new LegendRenderer(this.mViewPortHandler, this.mLegend);
        this.mXAxis = new XAxis();
        this.mDescPaint = new Paint(1);
        this.mInfoPaint = new Paint(1);
        this.mInfoPaint.setColor(Color.rgb((int)247, (int)189, (int)51));
        this.mInfoPaint.setTextAlign(Paint.Align.CENTER);
        this.mInfoPaint.setTextSize(Utils.convertDpToPixel(12.0f));
        if (this.mLogEnabled) {
            Log.i((String)"", (String)"Chart.init()");
        }
    }

    public void setData(T data) {
        this.mData = data;
        this.mOffsetsCalculated = false;
        if (data == null) {
            return;
        }
        this.setupDefaultFormatter(((ChartData)data).getYMin(), ((ChartData)data).getYMax());
        for (IDataSet set : ((ChartData)this.mData).getDataSets()) {
            if (!set.needsFormatter() && set.getValueFormatter() != this.mDefaultValueFormatter) continue;
            set.setValueFormatter(this.mDefaultValueFormatter);
        }
        this.notifyDataSetChanged();
        if (this.mLogEnabled) {
            Log.i((String)LOG_TAG, (String)"Data is set.");
        }
    }

    public void clear() {
        this.mData = null;
        this.mOffsetsCalculated = false;
        this.mIndicesToHighlight = null;
        this.mChartTouchListener.setLastHighlighted(null);
        this.invalidate();
    }

    public void clearValues() {
        ((ChartData)this.mData).clearValues();
        this.invalidate();
    }

    public boolean isEmpty() {
        if (this.mData == null) {
            return true;
        }
        return ((ChartData)this.mData).getEntryCount() <= 0;
    }

    public abstract void notifyDataSetChanged();

    protected abstract void calculateOffsets();

    protected abstract void calcMinMax();

    protected void setupDefaultFormatter(float min, float max) {
        float reference = 0.0f;
        reference = this.mData == null || ((ChartData)this.mData).getEntryCount() < 2 ? Math.max(Math.abs(min), Math.abs(max)) : Math.abs(max - min);
        int digits = Utils.getDecimals(reference);
        this.mDefaultValueFormatter.setup(digits);
    }

    protected void onDraw(Canvas canvas) {
        if (this.mData == null) {
            boolean hasText;
            boolean bl = hasText = !TextUtils.isEmpty((CharSequence)this.mNoDataText);
            if (hasText) {
                MPPointF c = this.getCenter();
                canvas.drawText(this.mNoDataText, c.x, c.y, this.mInfoPaint);
            }
            return;
        }
        if (!this.mOffsetsCalculated) {
            this.calculateOffsets();
            this.mOffsetsCalculated = true;
        }
    }

    protected void drawDescription(Canvas c) {
        if (this.mDescription != null && this.mDescription.isEnabled()) {
            float y;
            float x;
            MPPointF position = this.mDescription.getPosition();
            this.mDescPaint.setTypeface(this.mDescription.getTypeface());
            this.mDescPaint.setTextSize(this.mDescription.getTextSize());
            this.mDescPaint.setColor(this.mDescription.getTextColor());
            this.mDescPaint.setTextAlign(this.mDescription.getTextAlign());
            if (position == null) {
                x = (float)this.getWidth() - this.mViewPortHandler.offsetRight() - this.mDescription.getXOffset();
                y = (float)this.getHeight() - this.mViewPortHandler.offsetBottom() - this.mDescription.getYOffset();
            } else {
                x = position.x;
                y = position.y;
            }
            c.drawText(this.mDescription.getText(), x, y, this.mDescPaint);
        }
    }

    @Override
    public float getMaxHighlightDistance() {
        return this.mMaxHighlightDistance;
    }

    public void setMaxHighlightDistance(float distDp) {
        this.mMaxHighlightDistance = Utils.convertDpToPixel(distDp);
    }

    public Highlight[] getHighlighted() {
        return this.mIndicesToHighlight;
    }

    public boolean isHighlightPerTapEnabled() {
        return this.mHighLightPerTapEnabled;
    }

    public void setHighlightPerTapEnabled(boolean enabled) {
        this.mHighLightPerTapEnabled = enabled;
    }

    public boolean valuesToHighlight() {
        return this.mIndicesToHighlight != null && this.mIndicesToHighlight.length > 0 && this.mIndicesToHighlight[0] != null;
    }

    protected void setLastHighlighted(Highlight[] highs) {
        if (highs == null || highs.length <= 0 || highs[0] == null) {
            this.mChartTouchListener.setLastHighlighted(null);
        } else {
            this.mChartTouchListener.setLastHighlighted(highs[0]);
        }
    }

    public void highlightValues(Highlight[] highs) {
        this.mIndicesToHighlight = highs;
        this.setLastHighlighted(highs);
        this.invalidate();
    }

    public void highlightValue(float x, int dataSetIndex) {
        this.highlightValue(x, dataSetIndex, true);
    }

    public void highlightValue(float x, float y, int dataSetIndex) {
        this.highlightValue(x, y, dataSetIndex, true);
    }

    public void highlightValue(float x, int dataSetIndex, boolean callListener) {
        this.highlightValue(x, Float.NaN, dataSetIndex, callListener);
    }

    public void highlightValue(float x, float y, int dataSetIndex, boolean callListener) {
        if (dataSetIndex < 0 || dataSetIndex >= ((ChartData)this.mData).getDataSetCount()) {
            this.highlightValue(null, callListener);
        } else {
            this.highlightValue(new Highlight(x, y, dataSetIndex), callListener);
        }
    }

    public void highlightValue(Highlight highlight) {
        this.highlightValue(highlight, false);
    }

    public void highlightValue(Highlight high, boolean callListener) {
        Entry e = null;
        if (high == null) {
            this.mIndicesToHighlight = null;
        } else {
            if (this.mLogEnabled) {
                Log.i((String)LOG_TAG, (String)("Highlighted: " + high.toString()));
            }
            if ((e = ((ChartData)this.mData).getEntryForHighlight(high)) == null) {
                this.mIndicesToHighlight = null;
                high = null;
            } else {
                this.mIndicesToHighlight = new Highlight[]{high};
            }
        }
        this.setLastHighlighted(this.mIndicesToHighlight);
        if (callListener && this.mSelectionListener != null) {
            if (!this.valuesToHighlight()) {
                this.mSelectionListener.onNothingSelected();
            } else {
                this.mSelectionListener.onValueSelected(e, high);
            }
        }
        this.invalidate();
    }

    public Highlight getHighlightByTouchPoint(float x, float y) {
        if (this.mData == null) {
            Log.e((String)LOG_TAG, (String)"Can't select by touch. No data set.");
            return null;
        }
        return this.getHighlighter().getHighlight(x, y);
    }

    public void setOnTouchListener(ChartTouchListener l) {
        this.mChartTouchListener = l;
    }

    public ChartTouchListener getOnTouchListener() {
        return this.mChartTouchListener;
    }

    protected void drawMarkers(Canvas canvas) {
        if (this.mMarker == null || !this.isDrawMarkersEnabled() || !this.valuesToHighlight()) {
            return;
        }
        for (int i = 0; i < this.mIndicesToHighlight.length; ++i) {
            float[] pos;
            Highlight highlight = this.mIndicesToHighlight[i];
            Entry set = ((ChartData)this.mData).getDataSetByIndex(highlight.getDataSetIndex());
            Entry e = ((ChartData)this.mData).getEntryForHighlight(this.mIndicesToHighlight[i]);
            int entryIndex = set.getEntryIndex((Entry)e);
            if (e == null || (float)entryIndex > (float)set.getEntryCount() * this.mAnimator.getPhaseX() || !this.mViewPortHandler.isInBounds((pos = this.getMarkerPosition(highlight))[0], pos[1])) continue;
            this.mMarker.refreshContent(e, highlight);
            this.mMarker.draw(canvas, pos[0], pos[1]);
        }
    }

    protected float[] getMarkerPosition(Highlight high) {
        return new float[]{high.getDrawX(), high.getDrawY()};
    }

    public ChartAnimator getAnimator() {
        return this.mAnimator;
    }

    public boolean isDragDecelerationEnabled() {
        return this.mDragDecelerationEnabled;
    }

    public void setDragDecelerationEnabled(boolean enabled) {
        this.mDragDecelerationEnabled = enabled;
    }

    public float getDragDecelerationFrictionCoef() {
        return this.mDragDecelerationFrictionCoef;
    }

    public void setDragDecelerationFrictionCoef(float newValue) {
        if (newValue < 0.0f) {
            newValue = 0.0f;
        }
        if (newValue >= 1.0f) {
            newValue = 0.999f;
        }
        this.mDragDecelerationFrictionCoef = newValue;
    }

    @RequiresApi(value=11)
    public void animateXY(int durationMillisX, int durationMillisY, Easing.EasingFunction easingX, Easing.EasingFunction easingY) {
        this.mAnimator.animateXY(durationMillisX, durationMillisY, easingX, easingY);
    }

    @RequiresApi(value=11)
    public void animateXY(int durationMillisX, int durationMillisY, Easing.EasingFunction easing) {
        this.mAnimator.animateXY(durationMillisX, durationMillisY, easing);
    }

    @RequiresApi(value=11)
    public void animateX(int durationMillis, Easing.EasingFunction easing) {
        this.mAnimator.animateX(durationMillis, easing);
    }

    @RequiresApi(value=11)
    public void animateY(int durationMillis, Easing.EasingFunction easing) {
        this.mAnimator.animateY(durationMillis, easing);
    }

    @Deprecated
    public void animateXY(int durationMillisX, int durationMillisY, Easing.EasingOption easingX, Easing.EasingOption easingY) {
        this.mAnimator.animateXY(durationMillisX, durationMillisY, easingX, easingY);
    }

    @Deprecated
    public void animateX(int durationMillis, Easing.EasingOption easing) {
        this.mAnimator.animateX(durationMillis, easing);
    }

    @Deprecated
    public void animateY(int durationMillis, Easing.EasingOption easing) {
        this.mAnimator.animateY(durationMillis, easing);
    }

    @RequiresApi(value=11)
    public void animateX(int durationMillis) {
        this.mAnimator.animateX(durationMillis);
    }

    @RequiresApi(value=11)
    public void animateY(int durationMillis) {
        this.mAnimator.animateY(durationMillis);
    }

    @RequiresApi(value=11)
    public void animateXY(int durationMillisX, int durationMillisY) {
        this.mAnimator.animateXY(durationMillisX, durationMillisY);
    }

    public XAxis getXAxis() {
        return this.mXAxis;
    }

    @Override
    public IValueFormatter getDefaultValueFormatter() {
        return this.mDefaultValueFormatter;
    }

    public void setOnChartValueSelectedListener(OnChartValueSelectedListener l) {
        this.mSelectionListener = l;
    }

    public void setOnChartGestureListener(OnChartGestureListener l) {
        this.mGestureListener = l;
    }

    public OnChartGestureListener getOnChartGestureListener() {
        return this.mGestureListener;
    }

    public float getYMax() {
        return ((ChartData)this.mData).getYMax();
    }

    public float getYMin() {
        return ((ChartData)this.mData).getYMin();
    }

    @Override
    public float getXChartMax() {
        return this.mXAxis.mAxisMaximum;
    }

    @Override
    public float getXChartMin() {
        return this.mXAxis.mAxisMinimum;
    }

    @Override
    public float getXRange() {
        return this.mXAxis.mAxisRange;
    }

    public MPPointF getCenter() {
        return MPPointF.getInstance((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
    }

    @Override
    public MPPointF getCenterOffsets() {
        return this.mViewPortHandler.getContentCenter();
    }

    public void setExtraOffsets(float left, float top, float right, float bottom) {
        this.setExtraLeftOffset(left);
        this.setExtraTopOffset(top);
        this.setExtraRightOffset(right);
        this.setExtraBottomOffset(bottom);
    }

    public void setExtraTopOffset(float offset) {
        this.mExtraTopOffset = Utils.convertDpToPixel(offset);
    }

    public float getExtraTopOffset() {
        return this.mExtraTopOffset;
    }

    public void setExtraRightOffset(float offset) {
        this.mExtraRightOffset = Utils.convertDpToPixel(offset);
    }

    public float getExtraRightOffset() {
        return this.mExtraRightOffset;
    }

    public void setExtraBottomOffset(float offset) {
        this.mExtraBottomOffset = Utils.convertDpToPixel(offset);
    }

    public float getExtraBottomOffset() {
        return this.mExtraBottomOffset;
    }

    public void setExtraLeftOffset(float offset) {
        this.mExtraLeftOffset = Utils.convertDpToPixel(offset);
    }

    public float getExtraLeftOffset() {
        return this.mExtraLeftOffset;
    }

    public void setLogEnabled(boolean enabled) {
        this.mLogEnabled = enabled;
    }

    public boolean isLogEnabled() {
        return this.mLogEnabled;
    }

    public void setNoDataText(String text) {
        this.mNoDataText = text;
    }

    public void setNoDataTextColor(int color) {
        this.mInfoPaint.setColor(color);
    }

    public void setNoDataTextTypeface(Typeface tf) {
        this.mInfoPaint.setTypeface(tf);
    }

    public void setTouchEnabled(boolean enabled) {
        this.mTouchEnabled = enabled;
    }

    public void setMarker(IMarker marker) {
        this.mMarker = marker;
    }

    public IMarker getMarker() {
        return this.mMarker;
    }

    @Deprecated
    public void setMarkerView(IMarker v) {
        this.setMarker(v);
    }

    @Deprecated
    public IMarker getMarkerView() {
        return this.getMarker();
    }

    public void setDescription(Description desc) {
        this.mDescription = desc;
    }

    public Description getDescription() {
        return this.mDescription;
    }

    public Legend getLegend() {
        return this.mLegend;
    }

    public LegendRenderer getLegendRenderer() {
        return this.mLegendRenderer;
    }

    @Override
    public RectF getContentRect() {
        return this.mViewPortHandler.getContentRect();
    }

    public void disableScroll() {
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(true);
        }
    }

    public void enableScroll() {
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(false);
        }
    }

    public void setPaint(Paint p, int which) {
        switch (which) {
            case 7: {
                this.mInfoPaint = p;
                break;
            }
            case 11: {
                this.mDescPaint = p;
            }
        }
    }

    public Paint getPaint(int which) {
        switch (which) {
            case 7: {
                return this.mInfoPaint;
            }
            case 11: {
                return this.mDescPaint;
            }
        }
        return null;
    }

    @Deprecated
    public boolean isDrawMarkerViewsEnabled() {
        return this.isDrawMarkersEnabled();
    }

    @Deprecated
    public void setDrawMarkerViews(boolean enabled) {
        this.setDrawMarkers(enabled);
    }

    public boolean isDrawMarkersEnabled() {
        return this.mDrawMarkers;
    }

    public void setDrawMarkers(boolean enabled) {
        this.mDrawMarkers = enabled;
    }

    public T getData() {
        return this.mData;
    }

    public ViewPortHandler getViewPortHandler() {
        return this.mViewPortHandler;
    }

    public DataRenderer getRenderer() {
        return this.mRenderer;
    }

    public void setRenderer(DataRenderer renderer) {
        if (renderer != null) {
            this.mRenderer = renderer;
        }
    }

    public IHighlighter getHighlighter() {
        return this.mHighlighter;
    }

    public void setHighlighter(ChartHighlighter highlighter) {
        this.mHighlighter = highlighter;
    }

    @Override
    public MPPointF getCenterOfView() {
        return this.getCenter();
    }

    public Bitmap getChartBitmap() {
        Bitmap returnedBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(returnedBitmap);
        Drawable bgDrawable = this.getBackground();
        if (bgDrawable != null) {
            bgDrawable.draw(canvas);
        } else {
            canvas.drawColor(-1);
        }
        this.draw(canvas);
        return returnedBitmap;
    }

    public boolean saveToPath(String title, String pathOnSD) {
        Bitmap b = this.getChartBitmap();
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(Environment.getExternalStorageDirectory().getPath() + pathOnSD + "/" + title + ".png");
            b.compress(Bitmap.CompressFormat.PNG, 40, (OutputStream)stream);
            ((OutputStream)stream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean saveToGallery(String fileName, String subFolderPath, String fileDescription, Bitmap.CompressFormat format, int quality) {
        if (quality < 0 || quality > 100) {
            quality = 50;
        }
        long currentTime = System.currentTimeMillis();
        File extBaseDir = Environment.getExternalStorageDirectory();
        File file = new File(extBaseDir.getAbsolutePath() + "/DCIM/" + subFolderPath);
        if (!file.exists() && !file.mkdirs()) {
            return false;
        }
        String mimeType = "";
        switch (format) {
            case PNG: {
                mimeType = "image/png";
                if (fileName.endsWith(".png")) break;
                fileName = fileName + ".png";
                break;
            }
            case WEBP: {
                mimeType = "image/webp";
                if (fileName.endsWith(".webp")) break;
                fileName = fileName + ".webp";
                break;
            }
            default: {
                mimeType = "image/jpeg";
                if (fileName.endsWith(".jpg") || fileName.endsWith(".jpeg")) break;
                fileName = fileName + ".jpg";
            }
        }
        String filePath = file.getAbsolutePath() + "/" + fileName;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filePath);
            Bitmap b = this.getChartBitmap();
            b.compress(format, quality, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        long size = new File(filePath).length();
        ContentValues values = new ContentValues(8);
        values.put("title", fileName);
        values.put("_display_name", fileName);
        values.put("date_added", Long.valueOf(currentTime));
        values.put("mime_type", mimeType);
        values.put("description", fileDescription);
        values.put("orientation", Integer.valueOf(0));
        values.put("_data", filePath);
        values.put("_size", Long.valueOf(size));
        return this.getContext().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values) != null;
    }

    public boolean saveToGallery(String fileName, int quality) {
        return this.saveToGallery(fileName, "", "MPAndroidChart-Library Save", Bitmap.CompressFormat.PNG, quality);
    }

    public boolean saveToGallery(String fileName) {
        return this.saveToGallery(fileName, "", "MPAndroidChart-Library Save", Bitmap.CompressFormat.PNG, 40);
    }

    public void removeViewportJob(Runnable job) {
        this.mJobs.remove(job);
    }

    public void clearAllViewportJobs() {
        this.mJobs.clear();
    }

    public void addViewportJob(Runnable job) {
        if (this.mViewPortHandler.hasChartDimens()) {
            this.post(job);
        } else {
            this.mJobs.add(job);
        }
    }

    public ArrayList<Runnable> getJobs() {
        return this.mJobs;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).layout(left, top, right, bottom);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int size = (int)Utils.convertDpToPixel(50.0f);
        this.setMeasuredDimension(Math.max(this.getSuggestedMinimumWidth(), Chart.resolveSize((int)size, (int)widthMeasureSpec)), Math.max(this.getSuggestedMinimumHeight(), Chart.resolveSize((int)size, (int)heightMeasureSpec)));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.mLogEnabled) {
            Log.i((String)LOG_TAG, (String)"OnSizeChanged()");
        }
        if (w > 0 && h > 0 && w < 10000 && h < 10000) {
            if (this.mLogEnabled) {
                Log.i((String)LOG_TAG, (String)("Setting chart dimens, width: " + w + ", height: " + h));
            }
            this.mViewPortHandler.setChartDimens(w, h);
        } else if (this.mLogEnabled) {
            Log.w((String)LOG_TAG, (String)("*Avoiding* setting chart dimens! width: " + w + ", height: " + h));
        }
        this.notifyDataSetChanged();
        for (Runnable r : this.mJobs) {
            this.post(r);
        }
        this.mJobs.clear();
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public void setHardwareAccelerationEnabled(boolean enabled) {
        if (Build.VERSION.SDK_INT >= 11) {
            if (enabled) {
                this.setLayerType(2, null);
            } else {
                this.setLayerType(1, null);
            }
        } else {
            Log.e((String)LOG_TAG, (String)"Cannot enable/disable hardware acceleration for devices below API level 11.");
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mUnbind) {
            this.unbindDrawables((View)this);
        }
    }

    private void unbindDrawables(View view) {
        if (view.getBackground() != null) {
            view.getBackground().setCallback(null);
        }
        if (view instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup)view).getChildCount(); ++i) {
                this.unbindDrawables(((ViewGroup)view).getChildAt(i));
            }
            ((ViewGroup)view).removeAllViews();
        }
    }

    public void setUnbindEnabled(boolean enabled) {
        this.mUnbind = enabled;
    }
}

