/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer.scatter;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.github.mikephil.charting.buffer.ScatterBuffer;
import com.github.mikephil.charting.interfaces.datasets.IScatterDataSet;
import com.github.mikephil.charting.renderer.scatter.ShapeRenderer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;

public class CircleShapeRenderer
implements ShapeRenderer {
    @Override
    public void renderShape(Canvas c, IScatterDataSet dataSet, ViewPortHandler viewPortHandler, ScatterBuffer buffer, Paint renderPaint, float shapeSize) {
        float shapeHalf = shapeSize / 2.0f;
        float shapeHoleSizeHalf = Utils.convertDpToPixel(dataSet.getScatterShapeHoleRadius());
        float shapeHoleSize = shapeHoleSizeHalf * 2.0f;
        float shapeStrokeSize = (shapeSize - shapeHoleSize) / 2.0f;
        float shapeStrokeSizeHalf = shapeStrokeSize / 2.0f;
        int shapeHoleColor = dataSet.getScatterShapeHoleColor();
        for (int i = 0; i < buffer.size() && viewPortHandler.isInBoundsRight(buffer.buffer[i]); i += 2) {
            if (!viewPortHandler.isInBoundsLeft(buffer.buffer[i]) || !viewPortHandler.isInBoundsY(buffer.buffer[i + 1])) continue;
            renderPaint.setColor(dataSet.getColor(i / 2));
            if ((double)shapeSize > 0.0) {
                renderPaint.setStyle(Paint.Style.STROKE);
                renderPaint.setStrokeWidth(shapeStrokeSize);
                c.drawCircle(buffer.buffer[i], buffer.buffer[i + 1], shapeHoleSizeHalf + shapeStrokeSizeHalf, renderPaint);
                if (shapeHoleColor == 0x112233) continue;
                renderPaint.setStyle(Paint.Style.FILL);
                renderPaint.setColor(shapeHoleColor);
                c.drawCircle(buffer.buffer[i], buffer.buffer[i + 1], shapeHoleSizeHalf, renderPaint);
                continue;
            }
            renderPaint.setStyle(Paint.Style.FILL);
            c.drawCircle(buffer.buffer[i], buffer.buffer[i + 1], shapeHalf, renderPaint);
        }
    }
}

