/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.BarBuffer;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.highlight.Range;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.renderer.BarLineScatterCandleBubbleRenderer;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class BarChartRenderer
extends BarLineScatterCandleBubbleRenderer {
    protected BarDataProvider mChart;
    protected RectF mBarRect = new RectF();
    protected BarBuffer[] mBarBuffers;
    protected Paint mShadowPaint;
    protected Paint mBarBorderPaint;

    public BarChartRenderer(BarDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = chart;
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setStyle(Paint.Style.FILL);
        this.mHighlightPaint.setColor(Color.rgb((int)0, (int)0, (int)0));
        this.mHighlightPaint.setAlpha(120);
        this.mShadowPaint = new Paint(1);
        this.mShadowPaint.setStyle(Paint.Style.FILL);
        this.mBarBorderPaint = new Paint(1);
        this.mBarBorderPaint.setStyle(Paint.Style.STROKE);
    }

    @Override
    public void initBuffers() {
        BarData barData = this.mChart.getBarData();
        this.mBarBuffers = new BarBuffer[barData.getDataSetCount()];
        for (int i = 0; i < this.mBarBuffers.length; ++i) {
            IBarDataSet set = (IBarDataSet)barData.getDataSetByIndex(i);
            this.mBarBuffers[i] = new BarBuffer(set.getEntryCount() * 4 * (set.isStacked() ? set.getStackSize() : 1), barData.getDataSetCount(), set.isStacked());
        }
    }

    @Override
    public void drawData(Canvas c) {
        BarData barData = this.mChart.getBarData();
        for (int i = 0; i < barData.getDataSetCount(); ++i) {
            IBarDataSet set = (IBarDataSet)barData.getDataSetByIndex(i);
            if (!set.isVisible() || set.getEntryCount() <= 0) continue;
            this.drawDataSet(c, set, i);
        }
    }

    protected void drawDataSet(Canvas c, IBarDataSet dataSet, int index) {
        int j;
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        this.mShadowPaint.setColor(dataSet.getBarShadowColor());
        this.mBarBorderPaint.setColor(dataSet.getBarBorderColor());
        this.mBarBorderPaint.setStrokeWidth(Utils.convertDpToPixel(dataSet.getBarBorderWidth()));
        boolean drawBorder = dataSet.getBarBorderWidth() > 0.0f;
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        BarBuffer buffer = this.mBarBuffers[index];
        buffer.setPhases(phaseX, phaseY);
        buffer.setDataSet(index);
        buffer.setInverted(this.mChart.isInverted(dataSet.getAxisDependency()));
        buffer.setBarWidth(this.mChart.getBarData().getBarWidth());
        buffer.feed(dataSet);
        trans.pointValuesToPixel(buffer.buffer);
        if (this.mChart.isDrawBarShadowEnabled()) {
            for (j = 0; j < buffer.size(); j += 4) {
                if (!this.mViewPortHandler.isInBoundsLeft(buffer.buffer[j + 2])) continue;
                if (!this.mViewPortHandler.isInBoundsRight(buffer.buffer[j])) break;
                c.drawRect(buffer.buffer[j], this.mViewPortHandler.contentTop(), buffer.buffer[j + 2], this.mViewPortHandler.contentBottom(), this.mShadowPaint);
            }
        }
        if (dataSet.getColors().size() > 1) {
            for (j = 0; j < buffer.size(); j += 4) {
                if (!this.mViewPortHandler.isInBoundsLeft(buffer.buffer[j + 2])) continue;
                if (this.mViewPortHandler.isInBoundsRight(buffer.buffer[j])) {
                    this.mRenderPaint.setColor(dataSet.getColor(j / 4));
                    c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mRenderPaint);
                    if (!drawBorder) continue;
                    c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mBarBorderPaint);
                    continue;
                }
                break;
            }
        } else {
            this.mRenderPaint.setColor(dataSet.getColor());
            for (j = 0; j < buffer.size(); j += 4) {
                if (!this.mViewPortHandler.isInBoundsLeft(buffer.buffer[j + 2])) continue;
                if (this.mViewPortHandler.isInBoundsRight(buffer.buffer[j])) {
                    c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mRenderPaint);
                    if (!drawBorder) continue;
                    c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mBarBorderPaint);
                    continue;
                }
                break;
            }
        }
    }

    protected void prepareBarHighlight(float x, float y1, float y2, float barWidthHalf, Transformer trans) {
        float left = x - barWidthHalf;
        float right = x + barWidthHalf;
        float top = y1;
        float bottom = y2;
        this.mBarRect.set(left, top, right, bottom);
        trans.rectToPixelPhase(this.mBarRect, this.mAnimator.getPhaseY());
    }

    @Override
    public void drawValues(Canvas c) {
        if (this.isDrawingValuesAllowed(this.mChart)) {
            List dataSets = this.mChart.getBarData().getDataSets();
            float valueOffsetPlus = Utils.convertDpToPixel(4.5f);
            float posOffset = 0.0f;
            float negOffset = 0.0f;
            boolean drawValueAboveBar = this.mChart.isDrawValueAboveBarEnabled();
            block0: for (int i = 0; i < this.mChart.getBarData().getDataSetCount(); ++i) {
                IBarDataSet dataSet = (IBarDataSet)dataSets.get(i);
                if (!dataSet.isDrawValuesEnabled() || dataSet.getEntryCount() == 0) continue;
                this.applyValueTextStyle(dataSet);
                boolean isInverted = this.mChart.isInverted(dataSet.getAxisDependency());
                float valueTextHeight = Utils.calcTextHeight(this.mValuePaint, "8");
                posOffset = drawValueAboveBar ? -valueOffsetPlus : valueTextHeight + valueOffsetPlus;
                float f = negOffset = drawValueAboveBar ? valueTextHeight + valueOffsetPlus : -valueOffsetPlus;
                if (isInverted) {
                    posOffset = -posOffset - valueTextHeight;
                    negOffset = -negOffset - valueTextHeight;
                }
                BarBuffer buffer = this.mBarBuffers[i];
                if (!dataSet.isStacked()) {
                    float x;
                    int j = 0;
                    while ((float)j < (float)buffer.buffer.length * this.mAnimator.getPhaseX() && this.mViewPortHandler.isInBoundsRight(x = (buffer.buffer[j] + buffer.buffer[j + 2]) / 2.0f)) {
                        if (this.mViewPortHandler.isInBoundsY(buffer.buffer[j + 1]) && this.mViewPortHandler.isInBoundsLeft(x)) {
                            BarEntry entry = (BarEntry)dataSet.getEntryForIndex(j / 4);
                            float val = entry.getY();
                            this.drawValue(c, dataSet.getValueFormatter(), val, entry, i, x, val >= 0.0f ? buffer.buffer[j + 1] + posOffset : buffer.buffer[j + 3] + negOffset, dataSet.getValueTextColor(j / 4));
                        }
                        j += 4;
                    }
                    continue;
                }
                Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
                int bufferIndex = 0;
                int index = 0;
                while ((float)index < (float)dataSet.getEntryCount() * this.mAnimator.getPhaseX()) {
                    BarEntry entry = (BarEntry)dataSet.getEntryForIndex(index);
                    float[] vals = entry.getYVals();
                    float x = (buffer.buffer[bufferIndex] + buffer.buffer[bufferIndex + 2]) / 2.0f;
                    int color = dataSet.getValueTextColor(index);
                    if (vals == null) {
                        if (!this.mViewPortHandler.isInBoundsRight(x)) continue block0;
                        if (!this.mViewPortHandler.isInBoundsY(buffer.buffer[bufferIndex + 1]) || !this.mViewPortHandler.isInBoundsLeft(x)) continue;
                        this.drawValue(c, dataSet.getValueFormatter(), entry.getY(), entry, i, x, buffer.buffer[bufferIndex + 1] + (entry.getY() >= 0.0f ? posOffset : negOffset), color);
                    } else {
                        float[] transformed = new float[vals.length * 2];
                        float posY = 0.0f;
                        float negY = -entry.getNegativeSum();
                        int k = 0;
                        int idx = 0;
                        while (k < transformed.length) {
                            float y;
                            float value = vals[idx];
                            if (value >= 0.0f) {
                                y = posY += value;
                            } else {
                                y = negY;
                                negY -= value;
                            }
                            transformed[k + 1] = y * this.mAnimator.getPhaseY();
                            k += 2;
                            ++idx;
                        }
                        trans.pointValuesToPixel(transformed);
                        for (k = 0; k < transformed.length; k += 2) {
                            float y = transformed[k + 1] + (vals[k / 2] >= 0.0f ? posOffset : negOffset);
                            if (!this.mViewPortHandler.isInBoundsRight(x)) break;
                            if (!this.mViewPortHandler.isInBoundsY(y) || !this.mViewPortHandler.isInBoundsLeft(x)) continue;
                            this.drawValue(c, dataSet.getValueFormatter(), vals[k / 2], entry, i, x, y, color);
                        }
                    }
                    bufferIndex = vals == null ? bufferIndex + 4 : bufferIndex + 4 * vals.length;
                    ++index;
                }
            }
        }
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        BarData barData = this.mChart.getBarData();
        for (Highlight high : indices) {
            float y2;
            float y1;
            boolean isStack;
            BarEntry e;
            IBarDataSet set = (IBarDataSet)barData.getDataSetByIndex(high.getDataSetIndex());
            if (set == null || !set.isHighlightEnabled() || !this.isInBoundsX(e = (BarEntry)set.getEntryForXPos(high.getX()), set)) continue;
            Transformer trans = this.mChart.getTransformer(set.getAxisDependency());
            this.mHighlightPaint.setColor(set.getHighLightColor());
            this.mHighlightPaint.setAlpha(set.getHighLightAlpha());
            boolean bl = isStack = high.getStackIndex() >= 0 && e.isStacked();
            if (isStack) {
                if (this.mChart.isHighlightFullBarEnabled()) {
                    y1 = e.getPositiveSum();
                    y2 = -e.getNegativeSum();
                } else {
                    Range range = e.getRanges()[high.getStackIndex()];
                    y1 = range.from;
                    y2 = range.to;
                }
            } else {
                y1 = e.getY();
                y2 = 0.0f;
            }
            this.prepareBarHighlight(e.getX(), y1, y2, barData.getBarWidth() / 2.0f, trans);
            this.setHighlightDrawPos(high, this.mBarRect);
            c.drawRect(this.mBarRect, this.mHighlightPaint);
        }
    }

    protected void setHighlightDrawPos(Highlight high, RectF bar) {
        high.setDraw(bar.centerX(), bar.top);
    }

    @Override
    public void drawExtras(Canvas c) {
    }
}

