/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.data.BarLineScatterCandleBubbleDataSet;
import com.github.mikephil.charting.data.BubbleEntry;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.interfaces.datasets.IBubbleDataSet;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class BubbleDataSet
extends BarLineScatterCandleBubbleDataSet<BubbleEntry>
implements IBubbleDataSet {
    protected float mMaxSize;
    protected boolean mNormalizeSize = true;
    private float mHighlightCircleWidth = 2.5f;

    public BubbleDataSet(List<BubbleEntry> yVals, String label) {
        super(yVals, label);
    }

    @Override
    public void setHighlightCircleWidth(float width) {
        this.mHighlightCircleWidth = Utils.convertDpToPixel(width);
    }

    @Override
    public float getHighlightCircleWidth() {
        return this.mHighlightCircleWidth;
    }

    @Override
    public void calcMinMax() {
        if (this.mValues == null || this.mValues.isEmpty()) {
            return;
        }
        this.mYMax = -3.4028235E38f;
        this.mYMin = Float.MAX_VALUE;
        this.mXMax = -3.4028235E38f;
        this.mXMin = Float.MAX_VALUE;
        for (BubbleEntry e : this.mValues) {
            this.calcMinMax(e);
            float size = e.getSize();
            if (!(size > this.mMaxSize)) continue;
            this.mMaxSize = size;
        }
    }

    @Override
    public DataSet<BubbleEntry> copy() {
        ArrayList<BubbleEntry> yVals = new ArrayList<BubbleEntry>();
        for (int i = 0; i < this.mValues.size(); ++i) {
            yVals.add(((BubbleEntry)this.mValues.get(i)).copy());
        }
        BubbleDataSet copied = new BubbleDataSet((List<BubbleEntry>)yVals, this.getLabel());
        copied.mColors = this.mColors;
        copied.mHighLightColor = this.mHighLightColor;
        return copied;
    }

    @Override
    public float getMaxSize() {
        return this.mMaxSize;
    }

    @Override
    public boolean isNormalizeSizeEnabled() {
        return this.mNormalizeSize;
    }

    public void setNormalizeSizeEnabled(boolean normalizeSize) {
        this.mNormalizeSize = normalizeSize;
    }
}

