/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.util.AttributeSet;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BubbleData;
import com.github.mikephil.charting.data.CandleData;
import com.github.mikephil.charting.data.CombinedData;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.ScatterData;
import com.github.mikephil.charting.highlight.CombinedHighlighter;
import com.github.mikephil.charting.interfaces.dataprovider.CombinedDataProvider;
import com.github.mikephil.charting.renderer.CombinedChartRenderer;

public class CombinedChart
extends BarLineChartBase<CombinedData>
implements CombinedDataProvider {
    private boolean mDrawValueAboveBar = true;
    protected boolean mHighlightFullBarEnabled = false;
    private boolean mDrawBarShadow = false;
    protected DrawOrder[] mDrawOrder = new DrawOrder[]{DrawOrder.BAR, DrawOrder.BUBBLE, DrawOrder.LINE, DrawOrder.CANDLE, DrawOrder.SCATTER};

    public CombinedChart(Context context) {
        super(context);
    }

    public CombinedChart(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CombinedChart(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.setHighlighter(new CombinedHighlighter(this, this));
        this.setHighlightFullBarEnabled(true);
    }

    @Override
    public CombinedData getCombinedData() {
        return (CombinedData)this.mData;
    }

    @Override
    public void setData(CombinedData data) {
        this.mData = null;
        this.mRenderer = null;
        super.setData(data);
        this.setHighlighter(new CombinedHighlighter(this, this));
        this.mRenderer = new CombinedChartRenderer(this, this.mAnimator, this.mViewPortHandler);
        this.mRenderer.initBuffers();
    }

    @Override
    public LineData getLineData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getLineData();
    }

    @Override
    public BarData getBarData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getBarData();
    }

    @Override
    public ScatterData getScatterData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getScatterData();
    }

    @Override
    public CandleData getCandleData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getCandleData();
    }

    @Override
    public BubbleData getBubbleData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getBubbleData();
    }

    @Override
    public boolean isDrawBarShadowEnabled() {
        return this.mDrawBarShadow;
    }

    @Override
    public boolean isDrawValueAboveBarEnabled() {
        return this.mDrawValueAboveBar;
    }

    public void setDrawValueAboveBar(boolean enabled) {
        this.mDrawValueAboveBar = enabled;
    }

    public void setDrawBarShadow(boolean enabled) {
        this.mDrawBarShadow = enabled;
    }

    public void setHighlightFullBarEnabled(boolean enabled) {
        this.mHighlightFullBarEnabled = enabled;
    }

    @Override
    public boolean isHighlightFullBarEnabled() {
        return this.mHighlightFullBarEnabled;
    }

    public DrawOrder[] getDrawOrder() {
        return this.mDrawOrder;
    }

    public void setDrawOrder(DrawOrder[] order) {
        if (order == null || order.length <= 0) {
            return;
        }
        this.mDrawOrder = order;
    }

    public static enum DrawOrder {
        BAR,
        BUBBLE,
        LINE,
        CANDLE,
        SCATTER;

    }
}

