/*
 * Decompiled with CFR 0.152.
 */
package com.philjay.jwt;

import com.philjay.jwt.Base64Decoder;
import com.philjay.jwt.Base64Encoder;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/philjay/jwt/JWKObject;", "", "kty", "", "kid", "use", "alg", "n", "e", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAlg", "()Ljava/lang/String;", "getE", "getKid", "getKty", "getN", "getUse", "toRSA", "Ljava/security/PublicKey;", "decoder", "Lcom/philjay/jwt/Base64Decoder;", "toRSAString", "encoder", "Lcom/philjay/jwt/Base64Encoder;", "jwt"})
public class JWKObject {
    @NotNull
    private final String kty;
    @NotNull
    private final String kid;
    @NotNull
    private final String use;
    @NotNull
    private final String alg;
    @NotNull
    private final String n;
    @NotNull
    private final String e;

    public JWKObject(@NotNull String kty, @NotNull String kid, @NotNull String use, @NotNull String alg, @NotNull String n, @NotNull String e) {
        Intrinsics.checkNotNullParameter((Object)kty, (String)"kty");
        Intrinsics.checkNotNullParameter((Object)kid, (String)"kid");
        Intrinsics.checkNotNullParameter((Object)use, (String)"use");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.kty = kty;
        this.kid = kid;
        this.use = use;
        this.alg = alg;
        this.n = n;
        this.e = e;
    }

    @NotNull
    public final String getKty() {
        return this.kty;
    }

    @NotNull
    public final String getKid() {
        return this.kid;
    }

    @NotNull
    public final String getUse() {
        return this.use;
    }

    @NotNull
    public final String getAlg() {
        return this.alg;
    }

    @NotNull
    public final String getN() {
        return this.n;
    }

    @NotNull
    public final String getE() {
        return this.e;
    }

    @Nullable
    public PublicKey toRSA(@NotNull Base64Decoder decoder) {
        PublicKey publicKey;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            BigInteger modulus = new BigInteger(1, decoder.decode(this.n));
            BigInteger exponent = new BigInteger(1, decoder.decode(this.e));
            return kf.generatePublic(new RSAPublicKeySpec(modulus, exponent));
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
            publicKey = null;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            publicKey = null;
        }
        return publicKey;
    }

    @Nullable
    public String toRSAString(@NotNull Base64Encoder encoder, @NotNull Base64Decoder decoder) {
        String string;
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        try {
            PublicKey publicKey = this.toRSA(decoder);
            if (publicKey == null) {
                return null;
            }
            PublicKey rsa = publicKey;
            KeyFactory kf = KeyFactory.getInstance("RSA");
            Object object = kf.getKeySpec(rsa, X509EncodedKeySpec.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"kf.getKeySpec(rsa, X509EncodedKeySpec::class.java)");
            X509EncodedKeySpec spec = object;
            object = spec.getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"spec.encoded");
            return encoder.encode((byte[])object);
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
            string = null;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            string = null;
        }
        return string;
    }
}

