/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksigner.core.internal.zip;

import com.android.apksigner.core.internal.util.Pair;
import com.android.apksigner.core.util.DataSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class ZipUtils {
    public static final short COMPRESSION_METHOD_STORED = 0;
    public static final short COMPRESSION_METHOD_DEFLATED = 8;
    private static final int ZIP_EOCD_REC_MIN_SIZE = 22;
    private static final int ZIP_EOCD_REC_SIG = 101010256;
    private static final int ZIP_EOCD_CENTRAL_DIR_TOTAL_RECORD_COUNT_OFFSET = 10;
    private static final int ZIP_EOCD_CENTRAL_DIR_SIZE_FIELD_OFFSET = 12;
    private static final int ZIP_EOCD_CENTRAL_DIR_OFFSET_FIELD_OFFSET = 16;
    private static final int ZIP_EOCD_COMMENT_LENGTH_FIELD_OFFSET = 20;
    private static final int ZIP64_EOCD_LOCATOR_SIZE = 20;
    private static final int ZIP64_EOCD_LOCATOR_SIG = 117853008;
    private static final int UINT16_MAX_VALUE = 65535;

    private ZipUtils() {
    }

    public static void setZipEocdCentralDirectoryOffset(ByteBuffer zipEndOfCentralDirectory, long offset) {
        ZipUtils.assertByteOrderLittleEndian(zipEndOfCentralDirectory);
        ZipUtils.setUnsignedInt32(zipEndOfCentralDirectory, zipEndOfCentralDirectory.position() + 16, offset);
    }

    public static long getZipEocdCentralDirectoryOffset(ByteBuffer zipEndOfCentralDirectory) {
        ZipUtils.assertByteOrderLittleEndian(zipEndOfCentralDirectory);
        return ZipUtils.getUnsignedInt32(zipEndOfCentralDirectory, zipEndOfCentralDirectory.position() + 16);
    }

    public static long getZipEocdCentralDirectorySizeBytes(ByteBuffer zipEndOfCentralDirectory) {
        ZipUtils.assertByteOrderLittleEndian(zipEndOfCentralDirectory);
        return ZipUtils.getUnsignedInt32(zipEndOfCentralDirectory, zipEndOfCentralDirectory.position() + 12);
    }

    public static int getZipEocdCentralDirectoryTotalRecordCount(ByteBuffer zipEndOfCentralDirectory) {
        ZipUtils.assertByteOrderLittleEndian(zipEndOfCentralDirectory);
        return ZipUtils.getUnsignedInt16(zipEndOfCentralDirectory, zipEndOfCentralDirectory.position() + 10);
    }

    public static Pair<ByteBuffer, Long> findZipEndOfCentralDirectoryRecord(DataSource zip) throws IOException {
        long fileSize = zip.size();
        if (fileSize < 22L) {
            return null;
        }
        Pair<ByteBuffer, Long> result = ZipUtils.findZipEndOfCentralDirectoryRecord(zip, 0);
        if (result != null) {
            return result;
        }
        return ZipUtils.findZipEndOfCentralDirectoryRecord(zip, 65535);
    }

    private static Pair<ByteBuffer, Long> findZipEndOfCentralDirectoryRecord(DataSource zip, int maxCommentSize) throws IOException {
        if (maxCommentSize < 0 || maxCommentSize > 65535) {
            throw new IllegalArgumentException("maxCommentSize: " + maxCommentSize);
        }
        long fileSize = zip.size();
        if (fileSize < 22L) {
            return null;
        }
        maxCommentSize = (int)Math.min((long)maxCommentSize, fileSize - 22L);
        int maxEocdSize = 22 + maxCommentSize;
        long bufOffsetInFile = fileSize - (long)maxEocdSize;
        ByteBuffer buf = zip.getByteBuffer(bufOffsetInFile, maxEocdSize);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        int eocdOffsetInBuf = ZipUtils.findZipEndOfCentralDirectoryRecord(buf);
        if (eocdOffsetInBuf == -1) {
            return null;
        }
        buf.position(eocdOffsetInBuf);
        ByteBuffer eocd = buf.slice();
        eocd.order(ByteOrder.LITTLE_ENDIAN);
        return Pair.of(eocd, bufOffsetInFile + (long)eocdOffsetInBuf);
    }

    private static int findZipEndOfCentralDirectoryRecord(ByteBuffer zipContents) {
        ZipUtils.assertByteOrderLittleEndian(zipContents);
        int archiveSize = zipContents.capacity();
        if (archiveSize < 22) {
            return -1;
        }
        int maxCommentLength = Math.min(archiveSize - 22, 65535);
        int eocdWithEmptyCommentStartPosition = archiveSize - 22;
        for (int expectedCommentLength = 0; expectedCommentLength < maxCommentLength; ++expectedCommentLength) {
            int actualCommentLength;
            int eocdStartPos = eocdWithEmptyCommentStartPosition - expectedCommentLength;
            if (zipContents.getInt(eocdStartPos) != 101010256 || (actualCommentLength = ZipUtils.getUnsignedInt16(zipContents, eocdStartPos + 20)) != expectedCommentLength) continue;
            return eocdStartPos;
        }
        return -1;
    }

    public static final boolean isZip64EndOfCentralDirectoryLocatorPresent(DataSource zip, long zipEndOfCentralDirectoryPosition) throws IOException {
        long locatorPosition = zipEndOfCentralDirectoryPosition - 20L;
        if (locatorPosition < 0L) {
            return false;
        }
        ByteBuffer sig = zip.getByteBuffer(locatorPosition, 4);
        sig.order(ByteOrder.LITTLE_ENDIAN);
        return sig.getInt(0) == 117853008;
    }

    private static void assertByteOrderLittleEndian(ByteBuffer buffer) {
        if (buffer.order() != ByteOrder.LITTLE_ENDIAN) {
            throw new IllegalArgumentException("ByteBuffer byte order must be little endian");
        }
    }

    private static int getUnsignedInt16(ByteBuffer buffer, int offset) {
        return buffer.getShort(offset) & 0xFFFF;
    }

    private static void setUnsignedInt32(ByteBuffer buffer, int offset, long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("uint32 value of out range: " + value);
        }
        buffer.putInt(offset, (int)value);
    }

    private static long getUnsignedInt32(ByteBuffer buffer, int offset) {
        return (long)buffer.getInt(offset) & 0xFFFFFFFFL;
    }
}

