/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksigner.core;

import com.android.apksigner.core.apk.ApkUtils;
import com.android.apksigner.core.internal.apk.v2.V2SchemeVerifier;
import com.android.apksigner.core.util.DataSource;
import com.android.apksigner.core.zip.ZipFormatException;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class ApkVerifier {
    public Result verify(DataSource apk, int minSdkVersion) throws IOException, ZipFormatException {
        ApkUtils.ZipSections zipSections = ApkUtils.findZipSections(apk);
        Result result = new Result();
        try {
            V2SchemeVerifier.Result v2Result = V2SchemeVerifier.verify(apk, zipSections);
            result.mergeFrom(v2Result);
        }
        catch (V2SchemeVerifier.SignatureNotFoundException signatureNotFoundException) {
            // empty catch block
        }
        if (result.containsErrors()) {
            return result;
        }
        if (!result.isVerifiedUsingV2Scheme()) {
            return result;
        }
        result.setVerified();
        for (Result.V2SchemeSignerInfo signerInfo : result.getV2SchemeSigners()) {
            result.addSignerCertificate(signerInfo.getCertificate());
        }
        return result;
    }

    public static class IssueWithParams {
        private final Issue mIssue;
        private final Object[] mParams;

        public IssueWithParams(Issue issue, Object[] params) {
            this.mIssue = issue;
            this.mParams = params;
        }

        public Issue getIssue() {
            return this.mIssue;
        }

        public Object[] getParams() {
            return (Object[])this.mParams.clone();
        }

        public String toString() {
            return String.format(this.mIssue.getFormat(), this.mParams);
        }
    }

    public static enum Issue {
        V2_SIG_MALFORMED_SIGNERS("Malformed list of signers"),
        V2_SIG_MALFORMED_SIGNER("Malformed signer block"),
        V2_SIG_MALFORMED_PUBLIC_KEY("Malformed public key: %1$s"),
        V2_SIG_MALFORMED_CERTIFICATE("Malformed certificate #%2$d: %3$s"),
        V2_SIG_MALFORMED_SIGNATURE("Malformed APK Signature Scheme v2 signature record #%1$d"),
        V2_SIG_MALFORMED_DIGEST("Malformed APK Signature Scheme v2 digest record #%1$d"),
        V2_SIG_MALFORMED_ADDITIONAL_ATTRIBUTE("Malformed additional attribute #%1$d"),
        V2_SIG_NO_SIGNERS("No signers in APK Signature Scheme v2 signature"),
        V2_SIG_UNKNOWN_SIG_ALGORITHM("Unknown signature algorithm: %1$#x"),
        V2_SIG_UNKNOWN_ADDITIONAL_ATTRIBUTE("Unknown additional attribute: ID %1$#x"),
        V2_SIG_VERIFY_EXCEPTION("Failed to verify %1$s signature: %2$s"),
        V2_SIG_DID_NOT_VERIFY("%1$s signature over signed-data did not verify"),
        V2_SIG_NO_SIGNATURES("No signatures"),
        V2_SIG_NO_SUPPORTED_SIGNATURES("No supported signatures"),
        V2_SIG_NO_CERTIFICATES("No certificates"),
        V2_SIG_PUBLIC_KEY_MISMATCH_BETWEEN_CERTIFICATE_AND_SIGNATURES_RECORD("Public key mismatch between certificate and signature record: <%1$s> vs <%2$s>"),
        V2_SIG_SIG_ALG_MISMATCH_BETWEEN_SIGNATURES_AND_DIGESTS_RECORDS("Signature algorithms mismatch between signatures and digests records: %1$s vs %2$s"),
        V2_SIG_APK_DIGEST_DID_NOT_VERIFY("APK integrity check failed. %1$s digest mismatch. Expected: <%2$s>, actual: <%3$s>"),
        APK_SIG_BLOCK_UNKNOWN_ENTRY_ID("APK Signing Block contains unknown entry: ID %1$#x");

        private final String mFormat;

        private Issue(String format) {
            this.mFormat = format;
        }

        private String getFormat() {
            return this.mFormat;
        }
    }

    public static class Result {
        private final List<IssueWithParams> mErrors = new ArrayList<IssueWithParams>();
        private final List<IssueWithParams> mWarnings = new ArrayList<IssueWithParams>();
        private final List<X509Certificate> mSignerCerts = new ArrayList<X509Certificate>();
        private final List<V2SchemeSignerInfo> mV2SchemeSigners = new ArrayList<V2SchemeSignerInfo>();
        private boolean mVerified;
        private boolean mVerifiedUsingV2Scheme;

        public boolean isVerified() {
            return this.mVerified;
        }

        private void setVerified() {
            this.mVerified = true;
        }

        public boolean isVerifiedUsingV2Scheme() {
            return this.mVerifiedUsingV2Scheme;
        }

        public List<X509Certificate> getSignerCertificates() {
            return this.mSignerCerts;
        }

        private void addSignerCertificate(X509Certificate cert) {
            this.mSignerCerts.add(cert);
        }

        public List<V2SchemeSignerInfo> getV2SchemeSigners() {
            return this.mV2SchemeSigners;
        }

        public List<IssueWithParams> getErrors() {
            return this.mErrors;
        }

        public List<IssueWithParams> getWarnings() {
            return this.mWarnings;
        }

        private void mergeFrom(V2SchemeVerifier.Result source) {
            this.mVerifiedUsingV2Scheme = source.verified;
            this.mErrors.addAll(source.getErrors());
            this.mWarnings.addAll(source.getWarnings());
            for (V2SchemeVerifier.Result.SignerInfo signer : source.signers) {
                this.mV2SchemeSigners.add(new V2SchemeSignerInfo(signer));
            }
        }

        public boolean containsErrors() {
            if (!this.mErrors.isEmpty()) {
                return true;
            }
            if (!this.mV2SchemeSigners.isEmpty()) {
                for (V2SchemeSignerInfo signer : this.mV2SchemeSigners) {
                    if (!signer.containsErrors()) continue;
                    return true;
                }
            }
            return false;
        }

        public static class V2SchemeSignerInfo {
            private final int mIndex;
            private final List<X509Certificate> mCerts;
            private final List<IssueWithParams> mErrors;
            private final List<IssueWithParams> mWarnings;

            private V2SchemeSignerInfo(V2SchemeVerifier.Result.SignerInfo result) {
                this.mIndex = result.index;
                this.mCerts = result.certs;
                this.mErrors = result.getErrors();
                this.mWarnings = result.getWarnings();
            }

            public int getIndex() {
                return this.mIndex;
            }

            public X509Certificate getCertificate() {
                return this.mCerts.isEmpty() ? null : this.mCerts.get(0);
            }

            public List<X509Certificate> getCertificates() {
                return this.mCerts;
            }

            public boolean containsErrors() {
                return !this.mErrors.isEmpty();
            }

            public List<IssueWithParams> getErrors() {
                return this.mErrors;
            }

            public List<IssueWithParams> getWarnings() {
                return this.mWarnings;
            }
        }
    }
}

