/*
 * Decompiled with CFR 0.152.
 */
package com.othershe.combinebitmap.layout;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import com.othershe.combinebitmap.layout.ILayoutManager;

public class WechatLayoutManager
implements ILayoutManager {
    @Override
    public Bitmap combineBitmap(int size, int subSize, int gap, int gapColor, Bitmap[] bitmaps) {
        Bitmap result = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(result);
        if (gapColor == 0) {
            gapColor = -1;
        }
        canvas.drawColor(gapColor);
        int count = bitmaps.length;
        for (int i = 0; i < count; ++i) {
            if (bitmaps[i] == null) continue;
            Bitmap subBitmap = Bitmap.createScaledBitmap((Bitmap)bitmaps[i], (int)subSize, (int)subSize, (boolean)true);
            float x = 0.0f;
            float y = 0.0f;
            if (count == 2) {
                x = gap + i * (subSize + gap);
                y = (float)(size - subSize) / 2.0f;
            } else if (count == 3) {
                if (i == 0) {
                    x = (float)(size - subSize) / 2.0f;
                    y = gap;
                } else {
                    x = gap + (i - 1) * (subSize + gap);
                    y = subSize + 2 * gap;
                }
            } else if (count == 4) {
                x = gap + i % 2 * (subSize + gap);
                y = i < 2 ? (float)gap : (float)(subSize + 2 * gap);
            } else if (count == 5) {
                if (i == 0) {
                    x = y = (float)(size - 2 * subSize - gap) / 2.0f;
                } else if (i == 1) {
                    x = (float)(size + gap) / 2.0f;
                    y = (float)(size - 2 * subSize - gap) / 2.0f;
                } else if (i > 1) {
                    x = gap + (i - 2) * (subSize + gap);
                    y = (float)(size + gap) / 2.0f;
                }
            } else if (count == 6) {
                x = gap + i % 3 * (subSize + gap);
                y = i < 3 ? (float)(size - 2 * subSize - gap) / 2.0f : (float)(size + gap) / 2.0f;
            } else if (count == 7) {
                if (i == 0) {
                    x = (float)(size - subSize) / 2.0f;
                    y = gap;
                } else if (i < 4) {
                    x = gap + (i - 1) * (subSize + gap);
                    y = subSize + 2 * gap;
                } else {
                    x = gap + (i - 4) * (subSize + gap);
                    y = gap + 2 * (subSize + gap);
                }
            } else if (count == 8) {
                if (i == 0) {
                    x = (float)(size - 2 * subSize - gap) / 2.0f;
                    y = gap;
                } else if (i == 1) {
                    x = (float)(size + gap) / 2.0f;
                    y = gap;
                } else if (i < 5) {
                    x = gap + (i - 2) * (subSize + gap);
                    y = subSize + 2 * gap;
                } else {
                    x = gap + (i - 5) * (subSize + gap);
                    y = gap + 2 * (subSize + gap);
                }
            } else if (count == 9) {
                x = gap + i % 3 * (subSize + gap);
                y = i < 3 ? (float)gap : (i < 6 ? (float)(subSize + 2 * gap) : (float)(gap + 2 * (subSize + gap)));
            }
            canvas.drawBitmap(subBitmap, x, y, null);
        }
        return result;
    }
}

