/*
 * Decompiled with CFR 0.152.
 */
package com.othershe.combinebitmap.layout;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import com.othershe.combinebitmap.layout.ILayoutManager;

public class DingLayoutManager
implements ILayoutManager {
    @Override
    public Bitmap combineBitmap(int size, int subSize, int gap, int gapColor, Bitmap[] bitmaps) {
        Bitmap result = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(result);
        if (gapColor == 0) {
            gapColor = -1;
        }
        canvas.drawColor(gapColor);
        int count = bitmaps.length;
        int[][] dxy = new int[][]{{0, 0}, {1, 0}, {1, 1}, {0, 1}};
        for (int i = 0; i < count; ++i) {
            if (bitmaps[i] == null) continue;
            Bitmap subBitmap = Bitmap.createScaledBitmap((Bitmap)bitmaps[i], (int)size, (int)size, (boolean)true);
            if (count == 2 || count == 3 && i == 0) {
                subBitmap = Bitmap.createBitmap((Bitmap)subBitmap, (int)((size + gap) / 4), (int)0, (int)((size - gap) / 2), (int)size);
            } else if (count == 3 && (i == 1 || i == 2) || count == 4) {
                subBitmap = Bitmap.createBitmap((Bitmap)subBitmap, (int)((size + gap) / 4), (int)((size + gap) / 4), (int)((size - gap) / 2), (int)((size - gap) / 2));
            }
            int dx = dxy[i][0];
            int dy = dxy[i][1];
            canvas.drawBitmap(subBitmap, (float)(dx * (size + gap)) / 2.0f, (float)(dy * (size + gap)) / 2.0f, null);
        }
        return result;
    }
}

