/*
 * Decompiled with CFR 0.152.
 */
package com.othershe.combinebitmap.helper;

import android.support.annotation.NonNull;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPool {
    private int CPU_COUNT;
    private int CORE_POOL_SIZE;
    private int MAX_POOL_SIZE;
    private long KEEP_ALIVE;
    private ThreadPoolExecutor THREAD_POOL_EXECUTOR;
    private ThreadFactory sThreadFactory;

    private ThreadPool() {
        this.CORE_POOL_SIZE = this.CPU_COUNT = Runtime.getRuntime().availableProcessors();
        this.MAX_POOL_SIZE = 2 * this.CPU_COUNT + 1;
        this.KEEP_ALIVE = 10L;
        this.sThreadFactory = new ThreadFactory(){
            private final AtomicInteger mCount = new AtomicInteger();

            @Override
            public Thread newThread(@NonNull Runnable runnable) {
                return new Thread(runnable, "download_task#" + this.mCount.getAndIncrement());
            }
        };
    }

    public static ThreadPool getInstance() {
        return SingletonHolder.instance;
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        if (this.THREAD_POOL_EXECUTOR == null) {
            this.THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(this.CORE_POOL_SIZE, this.MAX_POOL_SIZE, this.KEEP_ALIVE, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), this.sThreadFactory);
        }
        return this.THREAD_POOL_EXECUTOR;
    }

    private static class SingletonHolder {
        private static final ThreadPool instance = new ThreadPool();

        private SingletonHolder() {
        }
    }
}

