/*
 * Decompiled with CFR 0.152.
 */
package com.othershe.combinebitmap.cache;

import android.graphics.Bitmap;
import android.support.v4.util.LruCache;

public class LruCacheHelper {
    private LruCache<String, Bitmap> mMemoryCache;

    public LruCacheHelper() {
        int maxMemory = (int)(Runtime.getRuntime().maxMemory() / 1024L);
        int cacheSize = maxMemory / 8;
        this.mMemoryCache = new LruCache<String, Bitmap>(cacheSize){

            protected int sizeOf(String key, Bitmap bitmap) {
                return bitmap.getRowBytes() * bitmap.getHeight() / 1024;
            }
        };
    }

    public void addBitmapToMemoryCache(String key, Bitmap bitmap) {
        if (this.getBitmapFromMemCache(key) == null) {
            this.mMemoryCache.put((Object)key, (Object)bitmap);
        }
    }

    public Bitmap getBitmapFromMemCache(String key) {
        return (Bitmap)this.mMemoryCache.get((Object)key);
    }
}

