/*
 * Decompiled with CFR 0.152.
 */
package cn.nodemedia;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLSurfaceView;
import android.util.Size;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class NodePublisher {
    public static final int LOG_LEVEL_ERROR = 0;
    public static final int LOG_LEVEL_INFO = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final int NMC_CODEC_ID_H264 = 27;
    public static final int NMC_CODEC_ID_H265 = 173;
    public static final int NMC_CODEC_ID_AAC = 86018;
    public static final int NMC_PROFILE_AUTO = 0;
    public static final int NMC_PROFILE_H264_BASELINE = 66;
    public static final int NMC_PROFILE_H264_MAIN = 77;
    public static final int NMC_PROFILE_H264_HIGH = 100;
    public static final int NMC_PROFILE_H265_MAIN = 1;
    public static final int NMC_PROFILE_AAC_LC = 1;
    public static final int NMC_PROFILE_AAC_HE = 4;
    public static final int NMC_PROFILE_AAC_HE_V2 = 28;
    public static final int NMC_PROFILE_AAC_LD = 22;
    public static final int NMC_PROFILE_AAC_ELD = 38;
    public static final int VIDEO_RC_CRF = 0;
    public static final int VIDEO_RC_ABR = 1;
    public static final int VIDEO_RC_CBR = 2;
    public static final int VIDEO_RC_VBV = 3;
    public static final int VIDEO_ORIENTATION_PORTRAIT = 0;
    public static final int VIDEO_ORIENTATION_LANDSCAPE_RIGHT = 1;
    public static final int VIDEO_ORIENTATION_LANDSCAPE_LEFT = 3;
    public static final int EffectorTextureTypeT2D = 0;
    public static final int EffectorTextureTypeEOS = 1;
    private static final String TAG = "NodeMedia.java";
    private OnNodePublisherEventListener onNodePublisherEventListener;
    private OnNodePublisherEffectorListener onNodePublisherEffectorListener;
    private GLCameraView glpv;
    private Camera mCamera;
    private Context ctx;
    private long id;
    private int fpsCount;
    private long fpsTime;
    private boolean isOpenFrontCamera = false;
    private int videoOrientation = 0;
    private int videoWidth = 720;
    private int videoHeight = 1280;
    private int cameraWidth = 0;
    private int cameraHeight = 0;
    private int surfaceWidth = 0;
    private int surfaceHeight = 0;
    private final FrameLayout.LayoutParams LP = new FrameLayout.LayoutParams(-1, -1, 17);

    public NodePublisher(@NonNull Context context, @NonNull String license) {
        this.ctx = context;
        this.id = this.jniInit(context, license);
    }

    public void setOnNodePublisherEventListener(OnNodePublisherEventListener onNodePublisherEventListener) {
        this.onNodePublisherEventListener = onNodePublisherEventListener;
    }

    public void setOnNodePublisherEffectorListener(OnNodePublisherEffectorListener onNodePublisherEffectorListener) {
        this.onNodePublisherEffectorListener = onNodePublisherEffectorListener;
    }

    public void attachView(@NonNull ViewGroup vg) {
        if (this.glpv == null) {
            this.glpv = new GLCameraView(this.ctx);
            this.glpv.setLayoutParams((ViewGroup.LayoutParams)this.LP);
            this.glpv.setKeepScreenOn(true);
            vg.addView((View)this.glpv);
        }
    }

    public void detachView() {
        if (this.glpv != null) {
            this.glpv.setKeepScreenOn(false);
            this.glpv = null;
            this.closeCamera();
            this.GPUImageDestroy();
        }
    }

    public void setVideoOrientation(int orientation) {
        this.videoOrientation = orientation;
    }

    public void openCamera(boolean frontCamera) {
        this.isOpenFrontCamera = frontCamera;
        ListenableFuture cameraProviderFuture = ProcessCameraProvider.getInstance((Context)this.ctx);
        cameraProviderFuture.addListener(() -> {
            try {
                ProcessCameraProvider cameraProvider = (ProcessCameraProvider)cameraProviderFuture.get();
                this.bindImageAnalysis(cameraProvider, this.isOpenFrontCamera);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }, ContextCompat.getMainExecutor((Context)this.ctx));
    }

    public void closeCamera() {
        ListenableFuture cameraProviderFuture = ProcessCameraProvider.getInstance((Context)this.ctx);
        cameraProviderFuture.addListener(() -> {
            try {
                ProcessCameraProvider cameraProvider = (ProcessCameraProvider)cameraProviderFuture.get();
                cameraProvider.unbindAll();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }, ContextCompat.getMainExecutor((Context)this.ctx));
    }

    public void switchCamera() {
        this.isOpenFrontCamera = !this.isOpenFrontCamera;
        this.closeCamera();
        this.openCamera(this.isOpenFrontCamera);
    }

    public Camera getCamera() {
        return this.mCamera;
    }

    public CameraInfo getCameraInfo() {
        return this.mCamera.getCameraInfo();
    }

    private void bindImageAnalysis(@NonNull ProcessCameraProvider cameraProvider, boolean front) {
        CameraSelector cameraSelector = front ? CameraSelector.DEFAULT_FRONT_CAMERA : CameraSelector.DEFAULT_BACK_CAMERA;
        Preview preview = new Preview.Builder().setTargetResolution(new Size(this.videoWidth, this.videoHeight)).setTargetRotation(this.videoOrientation).build();
        preview.setSurfaceProvider(this.glpv.getSurfaceProvider());
        this.mCamera = cameraProvider.bindToLifecycle((LifecycleOwner)this.ctx, cameraSelector, new UseCase[]{preview});
    }

    private void onEvent(int event, String msg) {
        if (this.onNodePublisherEventListener != null) {
            this.onNodePublisherEventListener.onEventCallback(this, event, msg);
        }
    }

    private void onCreateEffector() {
        if (this.onNodePublisherEffectorListener != null) {
            this.onNodePublisherEffectorListener.onCreateEffector(this.ctx);
        }
    }

    private int onProcessEffector(int textureID) {
        if (this.onNodePublisherEffectorListener != null) {
            textureID = this.onNodePublisherEffectorListener.onProcessEffector(textureID, this.videoWidth, this.videoHeight);
        }
        return textureID;
    }

    private void onReleaseEffector() {
        if (this.onNodePublisherEffectorListener != null) {
            this.onNodePublisherEffectorListener.onReleaseEffector();
        }
    }

    protected void finalize() {
        this.jniFree();
    }

    private native long jniInit(Context var1, String var2);

    private native void jniFree();

    public native void setLogLevel(int var1);

    public native void setHWAccelEnable(boolean var1);

    public native void setDenoiseEnable(boolean var1);

    public native void setVideoFrontMirror(boolean var1);

    public native void setCameraFrontMirror(boolean var1);

    public native void setAudioCodecParam(int var1, int var2, int var3, int var4, int var5);

    public native void setVideoCodecParam(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void setVideoRateControl(int var1);

    public native void setKeyFrameInterval(int var1);

    public native void setCryptoKey(@NonNull String var1);

    public native void setEnhancedRtmp(boolean var1);

    public native void setVolume(float var1);

    public native int addOutput(@NonNull String var1);

    public native int removeOutputs();

    public native int start(@NonNull String var1);

    public native int stop();

    public native void setEffectorTextureType(int var1);

    private native int GPUImageCreate(int var1);

    private native int GPUImageChange(int var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    private native int GPUImageDraw(int var1, float[] var2, int var3);

    private native int GPUImageDestroy();

    private native int GPUImageGenOESTextureID();

    private void onViewChange() {
        if (this.cameraWidth == 0 || this.cameraHeight == 0 || this.surfaceWidth == 0 || this.surfaceHeight == 0) {
            return;
        }
        WindowManager wm = (WindowManager)this.ctx.getSystemService("window");
        int surfaceRotation = wm.getDefaultDisplay().getRotation();
        int sensorRotationDegrees = this.getCameraInfo().getSensorRotationDegrees(this.videoOrientation);
        this.GPUImageChange(this.surfaceWidth, this.surfaceHeight, this.cameraWidth, this.cameraHeight, surfaceRotation, sensorRotationDegrees, this.isOpenFrontCamera);
    }

    static {
        System.loadLibrary("NodeMediaClient");
    }

    public static interface OnNodePublisherEventListener {
        public void onEventCallback(NodePublisher var1, int var2, String var3);
    }

    public static interface OnNodePublisherEffectorListener {
        public void onCreateEffector(Context var1);

        public int onProcessEffector(int var1, int var2, int var3);

        public void onReleaseEffector();
    }

    private class GLCameraView
    extends GLSurfaceView
    implements GLSurfaceView.Renderer {
        private static final String TAG = "NodeMedia.GLCameraView";
        private SurfaceTexture surfaceTexture;
        private int textureId;
        private Context context;
        private float[] transformMatrix;

        protected GLCameraView(Context context) {
            super(context);
            this.textureId = -1;
            this.transformMatrix = new float[16];
            this.context = context;
            this.setEGLContextClientVersion(2);
            this.setRenderer(this);
            this.setRenderMode(0);
        }

        private Preview.SurfaceProvider getSurfaceProvider() {
            return request -> {
                Size resolution = request.getResolution();
                this.surfaceTexture.setDefaultBufferSize(resolution.getWidth(), resolution.getHeight());
                request.provideSurface(new Surface(this.surfaceTexture), ContextCompat.getMainExecutor((Context)this.context), result -> result.getSurface().release());
                this.queueEvent(() -> {
                    NodePublisher.this.cameraWidth = resolution.getWidth();
                    NodePublisher.this.cameraHeight = resolution.getHeight();
                    NodePublisher.this.onViewChange();
                });
            };
        }

        public void onSurfaceCreated(GL10 gl10, EGLConfig eglConfig) {
            this.textureId = NodePublisher.this.GPUImageGenOESTextureID();
            this.surfaceTexture = new SurfaceTexture(this.textureId);
            this.surfaceTexture.setOnFrameAvailableListener(surfaceTexture -> this.requestRender());
            NodePublisher.this.GPUImageCreate(this.textureId);
        }

        public void onSurfaceChanged(GL10 gl10, int w, int h) {
            NodePublisher.this.surfaceWidth = w;
            NodePublisher.this.surfaceHeight = h;
            NodePublisher.this.onViewChange();
        }

        public void onDrawFrame(GL10 gl10) {
            this.surfaceTexture.updateTexImage();
            this.surfaceTexture.getTransformMatrix(this.transformMatrix);
            NodePublisher.this.GPUImageDraw(this.textureId, this.transformMatrix, this.transformMatrix.length);
        }
    }
}

