/*
 * Decompiled with CFR 0.152.
 */
package cn.nodemedia;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.media.AudioManager;
import android.support.annotation.NonNull;
import android.view.WindowManager;
import cn.nodemedia.NodeCameraView;
import cn.nodemedia.NodePublisherDelegate;
import cn.nodemedia.NodePublisherVideoTextureDelegate;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class NodePublisher
implements NodeCameraView.NodeCameraViewCallback {
    private long id;
    private WindowManager wm = null;
    private NodePublisherDelegate mNodePublisherDelegate;
    private NodePublisherVideoTextureDelegate mNodePublisherVideoTextureDelegate;
    private CapturePictureListener mCapturePictureListener;
    private NodeCameraView mNodeCameraView;
    private static AudioManager.OnAudioFocusChangeListener sAudioFocusChangeListener;
    private static List<NodePublisher> publishers;
    private String outputUrl;
    private String pageUrl;
    private String swfUrl;
    private String connArgs;
    private String cryptoKey;
    private boolean isFrontCamera;
    private boolean isDisplayFrontMirror;
    private boolean isStartPreview;
    private int cameraId;
    private int cameraOri;
    private int windowOri;
    private int cameraWidth;
    private int cameraHeight;
    private int surfaceWidth;
    private int surfaceHeight;
    private int logLevel;
    public static final int VIDEO_PPRESET_16X9_270 = 0;
    public static final int VIDEO_PPRESET_16X9_360 = 1;
    public static final int VIDEO_PPRESET_16X9_480 = 2;
    public static final int VIDEO_PPRESET_16X9_540 = 3;
    public static final int VIDEO_PPRESET_16X9_720 = 4;
    public static final int VIDEO_PPRESET_16X9_1080 = 5;
    public static final int VIDEO_PPRESET_4X3_270 = 10;
    public static final int VIDEO_PPRESET_4X3_360 = 11;
    public static final int VIDEO_PPRESET_4X3_480 = 12;
    public static final int VIDEO_PPRESET_4X3_540 = 13;
    public static final int VIDEO_PPRESET_4X3_720 = 14;
    public static final int VIDEO_PPRESET_4X3_1080 = 15;
    public static final int VIDEO_PPRESET_1X1_270 = 20;
    public static final int VIDEO_PPRESET_1X1_360 = 21;
    public static final int VIDEO_PPRESET_1X1_480 = 22;
    public static final int VIDEO_PPRESET_1X1_540 = 23;
    public static final int VIDEO_PPRESET_1X1_720 = 24;
    public static final int VIDEO_PPRESET_1X1_1080 = 25;
    public static final int AUDIO_PROFILE_LCAAC = 0;
    public static final int AUDIO_PROFILE_HEAAC = 1;
    public static final int VIDEO_PROFILE_BASELINE = 0;
    public static final int VIDEO_PROFILE_MAIN = 1;
    public static final int VIDEO_PROFILE_HIGH = 2;
    public static final int CAMERA_BACK = 0;
    public static final int CAMERA_FRONT = 1;
    public static final int NM_PIXEL_BGRA = 1;
    public static final int NM_PIXEL_RGBA = 2;
    public static final int NM_LOGLEVEL_ERROR = 0;
    public static final int NM_LOGLEVEL_INFO = 1;
    public static final int NM_LOGLEVEL_DEBUG = 2;

    public NodePublisher(@NonNull Context context) {
        this(context, "");
    }

    public NodePublisher(@NonNull Context context, @NonNull String license) {
        this.id = this.jniInit(context, license);
        this.outputUrl = "";
        this.pageUrl = "";
        this.swfUrl = "";
        this.connArgs = "";
        this.wm = (WindowManager)context.getSystemService("window");
        if (sAudioFocusChangeListener == null) {
            sAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

                public void onAudioFocusChange(int focusChange) {
                    block3: {
                        block2: {
                            if (focusChange != -2) break block2;
                            for (NodePublisher publisher : publishers) {
                                publisher.jniAudioMuted(true);
                            }
                            break block3;
                        }
                        if (focusChange != 1) break block3;
                        for (NodePublisher publisher : publishers) {
                            publisher.jniAudioMuted(false);
                        }
                    }
                }
            };
            AudioManager am = (AudioManager)context.getSystemService("audio");
            am.requestAudioFocus(sAudioFocusChangeListener, 3, 1);
        }
        publishers.add(this);
    }

    public void release() {
        final NodePublisher self = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                self.mNodePublisherDelegate = null;
                self.mNodeCameraView = null;
                self.wm = null;
                self.jniDeInit();
                self.jniFreeGPUImage();
                self.id = 0L;
                publishers.remove(self);
            }
        }).start();
    }

    private int getWindowRotation() {
        return this.wm.getDefaultDisplay().getRotation();
    }

    public void setOutputUrl(@NonNull String outputUrl) {
        this.outputUrl = outputUrl.trim();
    }

    public void setPageUrl(@NonNull String pageUrl) {
        this.pageUrl = pageUrl.trim();
    }

    public void setSwfUrl(@NonNull String swfUrl) {
        this.swfUrl = swfUrl.trim();
    }

    public void setConnArgs(@NonNull String connArgs) {
        this.connArgs = connArgs;
    }

    public void setCryptoKey(String cryptoKey) {
        this.cryptoKey = cryptoKey;
    }

    public void setCameraPreview(@NonNull NodeCameraView cameraPreview, int cameraID, boolean frontMirror) {
        this.mNodeCameraView = cameraPreview;
        this.mNodeCameraView.setNodeCameraViewCallback(this);
        this.cameraId = cameraID;
        this.isDisplayFrontMirror = frontMirror;
    }

    public void setAudioParam(int bitrate, int profile) {
        this.jniSetAudioParam(bitrate, profile, 44100);
    }

    public void setAudioParam(int bitrate, int profile, int sampleRate) {
        this.jniSetAudioParam(bitrate, profile, sampleRate);
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public int switchCamera() {
        if (this.mNodeCameraView == null) {
            return -1;
        }
        int ret = this.mNodeCameraView.switchCamera();
        this.cameraId = ret >= 0 ? ret : this.cameraId;
        return ret;
    }

    public int startPreview() {
        if (this.mNodeCameraView == null) {
            return -1;
        }
        int ret = this.mNodeCameraView.startPreview(this.cameraId);
        this.isFrontCamera = this.mNodeCameraView.isFrontCamera();
        this.cameraOri = this.mNodeCameraView.getCameraOrientation();
        this.windowOri = this.getWindowRotation();
        if (ret == 0) {
            this.isStartPreview = true;
        }
        return ret;
    }

    public int stopPreview() {
        if (this.mNodeCameraView == null) {
            return -1;
        }
        this.isStartPreview = false;
        return this.mNodeCameraView.stopPreview();
    }

    public int setZoomScale(int zoomScale) {
        if (this.mNodeCameraView == null) {
            return -1;
        }
        if (zoomScale < 0 || zoomScale > 100) {
            return -2;
        }
        return this.jniSetScaleGPUImage(zoomScale);
    }

    public int setFlashEnable(boolean flashEnable) {
        if (this.mNodeCameraView == null) {
            return -1;
        }
        return this.mNodeCameraView.setFlashEnable(flashEnable);
    }

    public int setAutoFocus(boolean autoFocus) {
        if (this.mNodeCameraView == null) {
            return -1;
        }
        return this.mNodeCameraView.setAutoFocus(autoFocus);
    }

    public void capturePicture(CapturePictureListener listener) {
        this.mCapturePictureListener = listener;
        this.jniRequestScreenShot();
    }

    public void setNodePublisherDelegate(@NonNull NodePublisherDelegate delegate) {
        this.mNodePublisherDelegate = delegate;
    }

    public void setNodePublisherVideoTextureDelegate(@NonNull NodePublisherVideoTextureDelegate nodePublisherVideoTextureDelegate) {
        this.mNodePublisherVideoTextureDelegate = nodePublisherVideoTextureDelegate;
        this.jniUseCustomFilter();
    }

    private void onEvent(int event, String eventMsg) {
        if (this.mNodePublisherDelegate != null) {
            this.mNodePublisherDelegate.onEventCallback(this, event, eventMsg);
        }
    }

    private void onCapture(byte[] pictureBuffer, int width, int height, int orientation) {
        if (this.mCapturePictureListener != null) {
            Bitmap sBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            sBitmap.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(pictureBuffer));
            Matrix matrix = new Matrix();
            matrix.postRotate((float)orientation);
            Bitmap dBitmap = Bitmap.createBitmap((Bitmap)sBitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
            sBitmap.recycle();
            this.mCapturePictureListener.onCaptureCallback(dBitmap);
        }
    }

    private native long jniInit(Object var1, String var2);

    private native void jniDeInit();

    private native int jniInitGPUImage();

    private native int jniChangeGPUImage(int var1, int var2, int var3, int var4);

    private native int jniDrawGPUImage(int var1);

    private native int jniFreeGPUImage();

    private native int jniSetScaleGPUImage(int var1);

    private native void jniRequestScreenShot();

    private native void jniAudioMuted(boolean var1);

    private native void jniSetAudioParam(int var1, int var2, int var3);

    private native void jniUseCustomFilter();

    public native void setVideoParam(int var1, int var2, int var3, int var4, boolean var5);

    public native void setAutoReconnectWaitTimeout(int var1);

    public native void setConnectWaitTimeout(int var1);

    public native void setBeautyLevel(int var1);

    public native void setHwEnable(boolean var1);

    public native void setAudioEnable(boolean var1);

    public native void setVideoEnable(boolean var1);

    public native void setDenoiseEnable(boolean var1);

    public native void setDynamicRateEnable(boolean var1);

    public native void setKeyFrameInterval(int var1);

    public native void setPublishType(int var1);

    public native int pushRawvideo(byte[] var1, int var2);

    public native int start();

    public native int stop();

    @Override
    public void OnCreate() {
        if (this.mNodePublisherVideoTextureDelegate != null) {
            this.mNodePublisherVideoTextureDelegate.onCreateTextureCallback(this);
        }
        this.jniInitGPUImage();
    }

    @Override
    public void OnChange(int cameraWidth, int cameraHeight, int surfaceWidth, int surfaceHeight) {
        this.cameraOri = this.mNodeCameraView.getCameraOrientation();
        this.windowOri = this.getWindowRotation();
        this.cameraWidth = cameraWidth;
        this.cameraHeight = cameraHeight;
        this.isFrontCamera = this.mNodeCameraView.isFrontCamera();
        if (this.mNodePublisherVideoTextureDelegate != null) {
            this.mNodePublisherVideoTextureDelegate.onChangeTextureCallback(this, this.isFrontCamera, this.cameraOri, this.windowOri);
        }
        this.jniChangeGPUImage(cameraWidth, cameraHeight, surfaceWidth, surfaceHeight);
    }

    @Override
    public void OnDraw(int textureId) {
        if (this.mNodePublisherVideoTextureDelegate != null) {
            textureId = this.mNodePublisherVideoTextureDelegate.onDrawTextureCallback(this, textureId, this.cameraWidth, this.cameraHeight, this.isFrontCamera, this.cameraOri);
        }
        this.jniDrawGPUImage(textureId);
    }

    @Override
    public void OnDestroy() {
        if (this.mNodePublisherVideoTextureDelegate != null) {
            this.mNodePublisherVideoTextureDelegate.onDestroyTextureCallback(this);
        }
        this.jniFreeGPUImage();
    }

    static {
        System.loadLibrary("NodeMediaClient");
        sAudioFocusChangeListener = null;
        publishers = new ArrayList<NodePublisher>(0);
    }

    public static interface CapturePictureListener {
        public void onCaptureCallback(Bitmap var1);
    }
}

