/*
 * Decompiled with CFR 0.152.
 */
package cn.nodemedia;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.View;
import android.widget.FrameLayout;
import java.util.List;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class NodeCameraView
extends FrameLayout
implements GLSurfaceView.Renderer,
SurfaceHolder.Callback,
SurfaceTexture.OnFrameAvailableListener {
    private static final String TAG = "NodeMedia.CameraView";
    public static final int NO_TEXTURE = -1;
    private GLSurfaceView mGLSurfaceView;
    private SurfaceTexture mSurfaceTexture;
    private Context mContext;
    private Camera mCamera;
    private int mTextureId = -1;
    private boolean isStarting;
    private boolean isAutoFocus = true;
    private int mCameraId = 0;
    private int mCameraNum = 0;
    private int mCameraWidth;
    private int mCameraHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private NodeCameraViewCallback mNodeCameraViewCallback;
    private boolean isMediaOverlay = false;

    public NodeCameraView(@NonNull Context context) {
        super(context);
        this.initView(context);
    }

    public NodeCameraView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public NodeCameraView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    @TargetApi(value=21)
    public NodeCameraView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mContext = context;
        this.mCameraNum = Camera.getNumberOfCameras();
    }

    private void createTexture() {
        if (this.mTextureId == -1) {
            Log.d((String)TAG, (String)"GL createTexture");
            this.mTextureId = this.getExternalOESTextureID();
            this.mSurfaceTexture = new SurfaceTexture(this.mTextureId);
            this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        }
    }

    private void destroyTexture() {
        if (this.mTextureId > -1) {
            Log.d((String)TAG, (String)"GL destroyTexture");
            this.mTextureId = -1;
            this.mSurfaceTexture.setOnFrameAvailableListener(null);
            this.mSurfaceTexture.release();
            this.mSurfaceTexture = null;
        }
    }

    public GLSurfaceView getGLSurfaceView() {
        return this.mGLSurfaceView;
    }

    public int startPreview(int cameraId) {
        if (this.isStarting) {
            return -1;
        }
        try {
            this.mCameraId = cameraId > this.mCameraNum - 1 ? 0 : cameraId;
            this.mCamera = Camera.open((int)this.mCameraId);
        }
        catch (Exception e) {
            return -2;
        }
        try {
            Camera.Parameters para = this.mCamera.getParameters();
            this.choosePreviewSize(para, 1920, 1080);
            this.mCamera.setParameters(para);
            this.setAutoFocus(this.isAutoFocus);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("startPreview setParameters:" + e.getMessage()));
        }
        this.mGLSurfaceView = new GLSurfaceView(this.mContext);
        this.mGLSurfaceView.setEGLContextClientVersion(2);
        this.mGLSurfaceView.setRenderer((GLSurfaceView.Renderer)this);
        this.mGLSurfaceView.setRenderMode(0);
        this.mGLSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.mGLSurfaceView.getHolder().setKeepScreenOn(true);
        this.mGLSurfaceView.setZOrderMediaOverlay(this.isMediaOverlay);
        this.addView((View)this.mGLSurfaceView);
        this.isStarting = true;
        return 0;
    }

    public int stopPreview() {
        if (!this.isStarting) {
            return -1;
        }
        this.isStarting = false;
        this.mGLSurfaceView.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (NodeCameraView.this.mNodeCameraViewCallback != null) {
                    NodeCameraView.this.mNodeCameraViewCallback.OnDestroy();
                }
            }
        });
        this.removeView((View)this.mGLSurfaceView);
        this.mGLSurfaceView = null;
        try {
            if (this.mCamera != null) {
                this.mCamera.stopPreview();
                this.mCamera.release();
                this.mCamera = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    private Camera.CameraInfo getCameraInfo() {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)this.mCameraId, (Camera.CameraInfo)cameraInfo);
        return cameraInfo;
    }

    public Camera.Size getPreviewSize() {
        return this.mCamera.getParameters().getPreviewSize();
    }

    public boolean isFrontCamera() {
        Camera.CameraInfo info = this.getCameraInfo();
        return info.facing == 1;
    }

    public int getCameraOrientation() {
        return this.getCameraInfo().orientation;
    }

    private void choosePreviewSize(Camera.Parameters parms, int width, int height) {
        Camera.Size ppsfv = parms.getPreferredPreviewSizeForVideo();
        if (ppsfv != null) {
            Log.d((String)TAG, (String)("Camera preferred preview size for video is " + ppsfv.width + "x" + ppsfv.height));
        }
        for (Camera.Size size : parms.getSupportedPreviewSizes()) {
            if (size.width != width || size.height != height) continue;
            parms.setPreviewSize(width, height);
            return;
        }
    }

    public int setAutoFocus(boolean isAutoFocus) {
        this.isAutoFocus = isAutoFocus;
        if (this.mCamera == null) {
            return -1;
        }
        Camera.Parameters parameters = this.mCamera.getParameters();
        if (isAutoFocus) {
            Log.i((String)"video", (String)Build.MODEL);
            List focusModes = parameters.getSupportedFocusModes();
            if ((Build.MODEL.startsWith("GT-I950") || Build.MODEL.endsWith("SCH-I959") || Build.MODEL.endsWith("MEIZU MX3")) && focusModes.contains("continuous-picture")) {
                parameters.setFocusMode("continuous-picture");
            } else if (focusModes.contains("continuous-video")) {
                parameters.setFocusMode("continuous-video");
            }
        } else {
            List fms = parameters.getSupportedFocusModes();
            if (fms.contains("auto")) {
                parameters.setFocusMode("auto");
            }
            this.mCamera.autoFocus(null);
        }
        this.mCamera.setParameters(parameters);
        return 0;
    }

    public int setFlashEnable(boolean on) {
        if (this.mCamera == null) {
            return -1;
        }
        Camera.Parameters parameters = this.mCamera.getParameters();
        List flashModes = parameters.getSupportedFlashModes();
        if (flashModes == null) {
            return -1;
        }
        if (flashModes.contains("torch") && flashModes.contains("off")) {
            int ret = 1;
            if (on) {
                parameters.setFlashMode("torch");
            } else {
                parameters.setFlashMode("off");
                ret = 0;
            }
            this.mCamera.setParameters(parameters);
            return ret;
        }
        return -1;
    }

    public int switchCamera() {
        if (this.mCameraNum <= 1) {
            return -1;
        }
        if (this.mCamera != null) {
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
        }
        this.mCameraId = this.mCameraId == 0 ? 1 : 0;
        try {
            this.mCamera = Camera.open((int)this.mCameraId);
        }
        catch (RuntimeException e) {
            return -2;
        }
        try {
            Camera.Parameters para = this.mCamera.getParameters();
            this.choosePreviewSize(para, 1280, 720);
            this.mCamera.setParameters(para);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("switchCamera setParameters:" + e.getMessage()));
        }
        this.setAutoFocus(this.isAutoFocus);
        try {
            this.mCamera.setPreviewTexture(this.mSurfaceTexture);
            this.mCamera.startPreview();
            this.mCameraWidth = this.getPreviewSize().width;
            this.mCameraHeight = this.getPreviewSize().height;
            this.mGLSurfaceView.queueEvent(new Runnable(){

                @Override
                public void run() {
                    if (NodeCameraView.this.mNodeCameraViewCallback != null) {
                        NodeCameraView.this.mNodeCameraViewCallback.OnChange(NodeCameraView.this.mCameraWidth, NodeCameraView.this.mCameraHeight, NodeCameraView.this.mSurfaceWidth, NodeCameraView.this.mSurfaceHeight);
                    }
                }
            });
            return this.mCameraId;
        }
        catch (Exception e) {
            return -3;
        }
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        Log.d((String)TAG, (String)"GL onSurfaceCreated");
        this.createTexture();
        if (this.mNodeCameraViewCallback != null) {
            this.mNodeCameraViewCallback.OnCreate();
        }
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        Log.d((String)TAG, (String)"GL onSurfaceChanged");
        this.mCameraWidth = this.getPreviewSize().width;
        this.mCameraHeight = this.getPreviewSize().height;
        this.mSurfaceWidth = width;
        this.mSurfaceHeight = height;
        if (this.mNodeCameraViewCallback != null) {
            this.mNodeCameraViewCallback.OnChange(this.mCameraWidth, this.mCameraHeight, this.mSurfaceWidth, this.mSurfaceHeight);
        }
        try {
            this.mCamera.setPreviewTexture(this.mSurfaceTexture);
            this.mCamera.startPreview();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onDrawFrame(GL10 gl) {
        this.mSurfaceTexture.updateTexImage();
        if (this.mNodeCameraViewCallback != null) {
            this.mNodeCameraViewCallback.OnDraw(this.mTextureId);
        }
    }

    public void setNodeCameraViewCallback(NodeCameraViewCallback callback) {
        this.mNodeCameraViewCallback = callback;
    }

    public void surfaceCreated(SurfaceHolder holder) {
        Log.d((String)TAG, (String)"SV surfaceCreated");
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Log.d((String)TAG, (String)"SV surfaceChanged");
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        Log.d((String)TAG, (String)"SV surfaceDestroyed");
        if (this.mNodeCameraViewCallback != null) {
            this.mNodeCameraViewCallback.OnDestroy();
        }
        if (!this.isStarting) {
            this.destroyTexture();
            if (this.mCamera != null) {
                this.mCamera.stopPreview();
                this.mCamera.release();
                this.mCamera = null;
            }
        }
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        if (this.mGLSurfaceView != null) {
            this.mGLSurfaceView.requestRender();
        }
    }

    public int getExternalOESTextureID() {
        int[] texture = new int[1];
        GLES20.glGenTextures((int)1, (int[])texture, (int)0);
        GLES20.glBindTexture((int)36197, (int)texture[0]);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        return texture[0];
    }

    static interface NodeCameraViewCallback {
        public void OnCreate();

        public void OnChange(int var1, int var2, int var3, int var4);

        public void OnDraw(int var1);

        public void OnDestroy();
    }
}

