/*
 * Decompiled with CFR 0.152.
 */
package net.nightwhistler.htmlspanner.handlers;

import android.graphics.Color;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import net.nightwhistler.htmlspanner.TagNodeHandler;
import net.nightwhistler.htmlspanner.spans.FontFamilySpan;
import org.htmlcleaner.TagNode;

public class FontHandler
extends TagNodeHandler {
    private static final String SERIF = "serif";
    private static final String SANS_SERIF = "sans-serif";

    @Override
    public void handleTagNode(TagNode node, SpannableStringBuilder builder, int start, int end) {
        String face = node.getAttributeByName("face");
        String size = node.getAttributeByName("size");
        String color = node.getAttributeByName("color");
        FontFamilySpan originalSpan = this.getFontFamilySpan(builder, start, end);
        FontFamilySpan fontSpan = SERIF.equalsIgnoreCase(face) ? new FontFamilySpan(this.getSpanner().getSerifFont()) : (SANS_SERIF.equalsIgnoreCase(face) ? new FontFamilySpan(this.getSpanner().getSansSerifFont()) : (originalSpan != null ? new FontFamilySpan(originalSpan.getFontFamily()) : new FontFamilySpan(this.getSpanner().getDefaultFont())));
        if (originalSpan != null) {
            fontSpan.setBold(originalSpan.isBold());
            fontSpan.setItalic(originalSpan.isItalic());
        }
        builder.setSpan((Object)fontSpan, start, end, 33);
        if (size != null) {
            try {
                int fontSize = Integer.parseInt(size);
                builder.setSpan((Object)new RelativeSizeSpan(FontHandler.translateFontSize(fontSize)), start, end, 33);
            }
            catch (NumberFormatException fontSize) {
                // empty catch block
            }
        }
        if (color != null) {
            int fontColor = -16777216;
            try {
                fontColor = Color.parseColor((String)color);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            builder.setSpan((Object)new ForegroundColorSpan(fontColor), start, end, 33);
        }
    }

    private static float translateFontSize(int fontSize) {
        switch (fontSize) {
            case 1: {
                return 0.6f;
            }
            case 2: {
                return 0.8f;
            }
            case 3: {
                return 1.0f;
            }
            case 4: {
                return 1.2f;
            }
            case 5: {
                return 1.4f;
            }
            case 6: {
                return 1.6f;
            }
            case 7: {
                return 1.8f;
            }
        }
        return 1.0f;
    }
}

