/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.netflix.iceberg.Schema;
import com.netflix.iceberg.types.Type;
import com.netflix.iceberg.types.TypeUtil;
import com.netflix.iceberg.types.Types;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

class ReassignIds
extends TypeUtil.CustomOrderSchemaVisitor<Type> {
    private final Schema sourceSchema;
    private Type sourceType;

    ReassignIds(Schema sourceSchema) {
        this.sourceSchema = sourceSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type schema(Schema schema, Supplier<Type> future) {
        this.sourceType = this.sourceSchema.asStruct();
        try {
            Type type = future.get();
            return type;
        }
        finally {
            this.sourceType = null;
        }
    }

    @Override
    public Type struct(Types.StructType struct, Iterable<Type> fieldTypes) {
        Preconditions.checkNotNull((Object)this.sourceType, (Object)"Evaluation must start with a schema.");
        Preconditions.checkArgument((boolean)this.sourceType.isStructType(), (Object)("Not a struct: " + this.sourceType));
        Types.StructType sourceStruct = this.sourceType.asStructType();
        List<Types.NestedField> fields = struct.fields();
        int length = fields.size();
        ArrayList types = Lists.newArrayList(fieldTypes);
        ArrayList newFields = Lists.newArrayListWithExpectedSize((int)length);
        for (int i = 0; i < length; ++i) {
            Types.NestedField field = fields.get(i);
            int sourceFieldId = sourceStruct.field(field.name()).fieldId();
            if (field.isRequired()) {
                newFields.add(Types.NestedField.required(sourceFieldId, field.name(), (Type)types.get(i), field.doc()));
                continue;
            }
            newFields.add(Types.NestedField.optional(sourceFieldId, field.name(), (Type)types.get(i), field.doc()));
        }
        return Types.StructType.of(newFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type field(Types.NestedField field, Supplier<Type> future) {
        Preconditions.checkArgument((boolean)this.sourceType.isStructType(), (Object)("Not a struct: " + this.sourceType));
        Types.StructType sourceStruct = this.sourceType.asStructType();
        Types.NestedField sourceField = sourceStruct.field(field.name());
        this.sourceType = sourceField.type();
        try {
            Type type = future.get();
            return type;
        }
        finally {
            this.sourceType = sourceStruct;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type list(Types.ListType list, Supplier<Type> elementTypeFuture) {
        Preconditions.checkArgument((boolean)this.sourceType.isListType(), (Object)("Not a list: " + this.sourceType));
        Types.ListType sourceList = this.sourceType.asListType();
        int sourceElementId = sourceList.elementId();
        this.sourceType = sourceList.elementType();
        try {
            if (list.isElementOptional()) {
                Types.ListType listType = Types.ListType.ofOptional(sourceElementId, elementTypeFuture.get());
                return listType;
            }
            Types.ListType listType = Types.ListType.ofRequired(sourceElementId, elementTypeFuture.get());
            return listType;
        }
        finally {
            this.sourceType = sourceList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type map(Types.MapType map, Supplier<Type> keyTypeFuture, Supplier<Type> valueTypeFuture) {
        Preconditions.checkArgument((boolean)this.sourceType.isMapType(), (Object)("Not a map: " + this.sourceType));
        Types.MapType sourceMap = this.sourceType.asMapType();
        int sourceKeyId = sourceMap.keyId();
        int sourceValueId = sourceMap.valueId();
        try {
            this.sourceType = sourceMap.keyType();
            Type keyType = keyTypeFuture.get();
            this.sourceType = sourceMap.valueType();
            Type valueType = valueTypeFuture.get();
            if (map.isValueOptional()) {
                Types.MapType mapType = Types.MapType.ofOptional(sourceKeyId, sourceValueId, keyType, valueType);
                return mapType;
            }
            Types.MapType mapType = Types.MapType.ofRequired(sourceKeyId, sourceValueId, keyType, valueType);
            return mapType;
        }
        finally {
            this.sourceType = sourceMap;
        }
    }

    @Override
    public Type primitive(Type.PrimitiveType primitive) {
        return primitive;
    }
}

