/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.types;

import com.google.common.collect.Lists;
import com.netflix.iceberg.Schema;
import com.netflix.iceberg.types.Type;
import com.netflix.iceberg.types.TypeUtil;
import com.netflix.iceberg.types.Types;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;

class AssignFreshIds
extends TypeUtil.CustomOrderSchemaVisitor<Type> {
    private final TypeUtil.NextID nextId;

    AssignFreshIds(TypeUtil.NextID nextId) {
        this.nextId = nextId;
    }

    @Override
    public Type schema(Schema schema, Supplier<Type> future) {
        return future.get();
    }

    @Override
    public Type struct(Types.StructType struct, Iterable<Type> futures) {
        List<Types.NestedField> fields = struct.fields();
        int length = struct.fields().size();
        ArrayList newIds = Lists.newArrayListWithExpectedSize((int)length);
        for (int i = 0; i < length; ++i) {
            newIds.add(this.nextId.get());
        }
        ArrayList newFields = Lists.newArrayListWithExpectedSize((int)length);
        Iterator<Type> types = futures.iterator();
        for (int i = 0; i < length; ++i) {
            Types.NestedField field = fields.get(i);
            Type type = types.next();
            if (field.isOptional()) {
                newFields.add(Types.NestedField.optional((Integer)newIds.get(i), field.name(), type, field.doc()));
                continue;
            }
            newFields.add(Types.NestedField.required((Integer)newIds.get(i), field.name(), type, field.doc()));
        }
        return Types.StructType.of(newFields);
    }

    @Override
    public Type field(Types.NestedField field, Supplier<Type> future) {
        return future.get();
    }

    @Override
    public Type list(Types.ListType list, Supplier<Type> future) {
        int newId = this.nextId.get();
        if (list.isElementOptional()) {
            return Types.ListType.ofOptional(newId, future.get());
        }
        return Types.ListType.ofRequired(newId, future.get());
    }

    @Override
    public Type map(Types.MapType map, Supplier<Type> keyFuture, Supplier<Type> valuefuture) {
        int newKeyId = this.nextId.get();
        int newValueId = this.nextId.get();
        if (map.isValueOptional()) {
            return Types.MapType.ofOptional(newKeyId, newValueId, keyFuture.get(), valuefuture.get());
        }
        return Types.MapType.ofRequired(newKeyId, newValueId, keyFuture.get(), valuefuture.get());
    }

    @Override
    public Type primitive(Type.PrimitiveType primitive) {
        return primitive;
    }
}

