/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.transforms;

import com.netflix.iceberg.expressions.BoundPredicate;
import com.netflix.iceberg.expressions.Expression;
import com.netflix.iceberg.expressions.Expressions;
import com.netflix.iceberg.expressions.UnboundPredicate;
import com.netflix.iceberg.transforms.ProjectionUtil;
import com.netflix.iceberg.transforms.Transform;
import com.netflix.iceberg.transforms.TransformUtil;
import com.netflix.iceberg.types.Type;
import com.netflix.iceberg.types.Types;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;

enum Timestamps implements Transform<Long, Integer>
{
    YEAR(ChronoUnit.YEARS, "year"),
    MONTH(ChronoUnit.MONTHS, "month"),
    DAY(ChronoUnit.DAYS, "day"),
    HOUR(ChronoUnit.HOURS, "hour");

    private static final OffsetDateTime EPOCH;
    private final ChronoUnit granularity;
    private final String name;

    private Timestamps(ChronoUnit granularity, String name) {
        this.granularity = granularity;
        this.name = name;
    }

    @Override
    public Integer apply(Long timestampMicros) {
        OffsetDateTime timestamp = Instant.ofEpochSecond(timestampMicros / 1000000L).atOffset(ZoneOffset.UTC);
        return (int)this.granularity.between(EPOCH, timestamp);
    }

    @Override
    public boolean canTransform(Type type) {
        return type.typeId() == Type.TypeID.TIMESTAMP;
    }

    @Override
    public Type getResultType(Type sourceType) {
        return Types.IntegerType.get();
    }

    @Override
    public UnboundPredicate<Integer> project(String name, BoundPredicate<Long> pred) {
        if (pred.op() == Expression.Operation.NOT_NULL || pred.op() == Expression.Operation.IS_NULL) {
            return Expressions.predicate(pred.op(), name);
        }
        return ProjectionUtil.truncateLong(name, pred, this);
    }

    @Override
    public UnboundPredicate<Integer> projectStrict(String name, BoundPredicate<Long> predicate) {
        return null;
    }

    @Override
    public String toHumanString(Integer value) {
        if (value == null) {
            return "null";
        }
        switch (this.granularity) {
            case YEARS: {
                return TransformUtil.humanYear(value);
            }
            case MONTHS: {
                return TransformUtil.humanMonth(value);
            }
            case DAYS: {
                return TransformUtil.humanDay(value);
            }
            case HOURS: {
                return TransformUtil.humanHour(value);
            }
        }
        throw new UnsupportedOperationException("Unsupported time unit: " + this.granularity);
    }

    public String toString() {
        return this.name;
    }

    static {
        EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    }
}

