/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.transforms;

import com.netflix.iceberg.expressions.BoundPredicate;
import com.netflix.iceberg.expressions.Expression;
import com.netflix.iceberg.expressions.Expressions;
import com.netflix.iceberg.expressions.UnboundPredicate;
import com.netflix.iceberg.transforms.Transform;
import java.math.BigDecimal;
import java.math.BigInteger;

class ProjectionUtil {
    ProjectionUtil() {
    }

    static <T> UnboundPredicate<T> truncateInteger(String name, BoundPredicate<Integer> pred, Transform<Integer, T> transform) {
        int boundary = (Integer)pred.literal().value();
        switch (pred.op()) {
            case LT: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(boundary - 1));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(boundary));
            }
            case GT: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(boundary + 1));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(boundary));
            }
            case EQ: {
                return Expressions.predicate(pred.op(), name, transform.apply(boundary));
            }
        }
        return null;
    }

    static <T> UnboundPredicate<T> truncateLong(String name, BoundPredicate<Long> pred, Transform<Long, T> transform) {
        long boundary = (Long)pred.literal().value();
        switch (pred.op()) {
            case LT: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(boundary - 1L));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(boundary));
            }
            case GT: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(boundary + 1L));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(boundary));
            }
            case EQ: {
                return Expressions.predicate(pred.op(), name, transform.apply(boundary));
            }
        }
        return null;
    }

    static <T> UnboundPredicate<T> truncateDecimal(String name, BoundPredicate<BigDecimal> pred, Transform<BigDecimal, T> transform) {
        BigDecimal boundary = (BigDecimal)pred.literal().value();
        switch (pred.op()) {
            case LT: {
                BigDecimal minusOne = new BigDecimal(boundary.unscaledValue().subtract(BigInteger.ONE), boundary.scale());
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(minusOne));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(boundary));
            }
            case GT: {
                BigDecimal plusOne = new BigDecimal(boundary.unscaledValue().add(BigInteger.ONE), boundary.scale());
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(plusOne));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(boundary));
            }
            case EQ: {
                return Expressions.predicate(pred.op(), name, transform.apply(boundary));
            }
        }
        return null;
    }

    static <S, T> UnboundPredicate<T> truncateArray(String name, BoundPredicate<S> pred, Transform<S, T> transform) {
        Object boundary = pred.literal().value();
        switch (pred.op()) {
            case LT: 
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(boundary));
            }
            case GT: 
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(boundary));
            }
            case EQ: {
                return Expressions.predicate(Expression.Operation.EQ, name, transform.apply(boundary));
            }
        }
        return null;
    }
}

