/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.io;

import com.google.common.base.Preconditions;
import com.netflix.iceberg.io.CloseableGroup;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;

public interface CloseableIterable<T>
extends Iterable<T>,
Closeable {
    public static <E> CloseableIterable<E> withNoopClose(final Iterable<E> iterable) {
        return new CloseableIterable<E>(){

            @Override
            public void close() {
            }

            @Override
            public Iterator<E> iterator() {
                return iterable.iterator();
            }
        };
    }

    public static <E> CloseableIterable<E> empty() {
        return new CloseableIterable<E>(){

            @Override
            public void close() {
            }

            @Override
            public Iterator<E> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    public static <E> CloseableIterable<E> combine(Iterable<E> iterable, Iterable<Closeable> closeables) {
        return new CloseableGroup.ClosingIterable<E>(iterable, closeables);
    }

    public static <I, O> CloseableIterable<O> wrap(final CloseableIterable<I> iterable, Function<Iterable<I>, Iterable<O>> wrap) {
        final Iterable<O> wrappedIterable = wrap.apply(iterable);
        return new CloseableIterable<O>(){

            @Override
            public void close() throws IOException {
                iterable.close();
            }

            @Override
            public Iterator<O> iterator() {
                return wrappedIterable.iterator();
            }
        };
    }

    public static <I, O> CloseableIterable<O> transform(final CloseableIterable<I> iterable, final Function<I, O> transform) {
        Preconditions.checkNotNull(transform, (Object)"Cannot apply a null transform");
        return new CloseableIterable<O>(){

            @Override
            public void close() throws IOException {
                iterable.close();
            }

            @Override
            public Iterator<O> iterator() {
                return new Iterator<O>(){
                    private final Iterator<I> inner;
                    {
                        this.inner = iterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.inner.hasNext();
                    }

                    @Override
                    public O next() {
                        return transform.apply(this.inner.next());
                    }
                };
            }
        };
    }
}

