/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.io;

import com.google.common.collect.Lists;
import com.netflix.iceberg.io.CloseableIterable;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class CloseableGroup
implements Closeable {
    private final LinkedList<Closeable> closeables = Lists.newLinkedList();

    protected void addCloseable(Closeable closeable) {
        this.closeables.add(closeable);
    }

    @Override
    public void close() throws IOException {
        while (!this.closeables.isEmpty()) {
            Closeable toClose = this.closeables.removeFirst();
            if (toClose == null) continue;
            toClose.close();
        }
    }

    static class ClosingIterable<T>
    extends CloseableGroup
    implements CloseableIterable<T> {
        private final Iterable<T> iterable;

        public ClosingIterable(Iterable<T> iterable, Iterable<Closeable> closeables) {
            this.iterable = iterable;
            if (iterable instanceof Closeable) {
                this.addCloseable((Closeable)((Object)iterable));
            }
            for (Closeable closeable : closeables) {
                this.addCloseable(closeable);
            }
        }

        @Override
        public Iterator<T> iterator() {
            return this.iterable.iterator();
        }
    }
}

