/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.expressions;

import com.netflix.iceberg.expressions.False;
import com.netflix.iceberg.expressions.Literals;
import com.netflix.iceberg.expressions.True;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.ByteBuffer;

class SerializationProxies {
    SerializationProxies() {
    }

    static class FixedLiteralProxy
    implements Serializable {
        protected byte[] bytes;

        FixedLiteralProxy() {
        }

        FixedLiteralProxy(ByteBuffer buffer) {
            this.bytes = new byte[buffer.remaining()];
            buffer.duplicate().get(this.bytes);
        }

        Object readResolve() throws ObjectStreamException {
            return new Literals.FixedLiteral(ByteBuffer.wrap(this.bytes));
        }
    }

    static class BinaryLiteralProxy
    extends FixedLiteralProxy {
        BinaryLiteralProxy() {
        }

        BinaryLiteralProxy(ByteBuffer buffer) {
            super(buffer);
        }

        @Override
        Object readResolve() throws ObjectStreamException {
            return new Literals.BinaryLiteral(ByteBuffer.wrap(this.bytes));
        }
    }

    static class ConstantExpressionProxy
    implements Serializable {
        private Boolean trueOrFalse = null;

        public ConstantExpressionProxy() {
        }

        public ConstantExpressionProxy(boolean trueOrFalse) {
            this.trueOrFalse = trueOrFalse;
        }

        Object readResolve() throws ObjectStreamException {
            if (this.trueOrFalse.booleanValue()) {
                return True.INSTANCE;
            }
            return False.INSTANCE;
        }
    }
}

