/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.expressions;

import com.netflix.iceberg.PartitionField;
import com.netflix.iceberg.PartitionSpec;
import com.netflix.iceberg.expressions.BoundPredicate;
import com.netflix.iceberg.expressions.BoundReference;
import com.netflix.iceberg.expressions.Expression;
import com.netflix.iceberg.expressions.ExpressionVisitors;
import com.netflix.iceberg.expressions.Expressions;
import com.netflix.iceberg.expressions.RewriteNot;
import com.netflix.iceberg.expressions.UnboundPredicate;

public class Projections {
    private Projections() {
    }

    public static ProjectionEvaluator inclusive(PartitionSpec spec) {
        return new InclusiveProjection(spec);
    }

    public static ProjectionEvaluator strict(PartitionSpec spec) {
        return new StrictProjection(spec);
    }

    private static class StrictProjection
    extends BaseProjectionEvaluator {
        private StrictProjection(PartitionSpec spec) {
            super(spec);
        }

        @Override
        public <T> Expression predicate(BoundPredicate<T> pred) {
            PartitionField part = this.spec.getFieldBySourceId(((BoundReference)pred.ref()).fieldId());
            if (part == null) {
                return this.alwaysFalse();
            }
            UnboundPredicate<?> result = part.transform().projectStrict(part.name(), pred);
            if (result != null) {
                return result;
            }
            return this.alwaysFalse();
        }
    }

    private static class InclusiveProjection
    extends BaseProjectionEvaluator {
        private InclusiveProjection(PartitionSpec spec) {
            super(spec);
        }

        @Override
        public <T> Expression predicate(BoundPredicate<T> pred) {
            PartitionField part = this.spec.getFieldBySourceId(((BoundReference)pred.ref()).fieldId());
            if (part == null) {
                return this.alwaysTrue();
            }
            UnboundPredicate<?> result = part.transform().project(part.name(), pred);
            if (result != null) {
                return result;
            }
            return this.alwaysTrue();
        }
    }

    private static class BaseProjectionEvaluator
    extends ProjectionEvaluator {
        final PartitionSpec spec;

        private BaseProjectionEvaluator(PartitionSpec spec) {
            this.spec = spec;
        }

        @Override
        public Expression project(Expression expr) {
            return ExpressionVisitors.visit(ExpressionVisitors.visit(expr, RewriteNot.get()), this);
        }

        @Override
        public Expression alwaysTrue() {
            return Expressions.alwaysTrue();
        }

        @Override
        public Expression alwaysFalse() {
            return Expressions.alwaysFalse();
        }

        @Override
        public Expression not(Expression result) {
            throw new UnsupportedOperationException("[BUG] project called on expression with a not");
        }

        @Override
        public Expression and(Expression leftResult, Expression rightResult) {
            return Expressions.and(leftResult, rightResult);
        }

        @Override
        public Expression or(Expression leftResult, Expression rightResult) {
            return Expressions.or(leftResult, rightResult);
        }

        @Override
        public <T> Expression predicate(UnboundPredicate<T> pred) {
            Expression bound = pred.bind(this.spec.schema().asStruct(), true);
            if (bound instanceof BoundPredicate) {
                return (Expression)this.predicate((BoundPredicate)bound);
            }
            return bound;
        }
    }

    public static abstract class ProjectionEvaluator
    extends ExpressionVisitors.ExpressionVisitor<Expression> {
        public abstract Expression project(Expression var1);
    }
}

