/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.expressions;

import com.netflix.iceberg.ManifestFile;
import com.netflix.iceberg.PartitionSpec;
import com.netflix.iceberg.expressions.Binder;
import com.netflix.iceberg.expressions.BoundReference;
import com.netflix.iceberg.expressions.Expression;
import com.netflix.iceberg.expressions.ExpressionVisitors;
import com.netflix.iceberg.expressions.Expressions;
import com.netflix.iceberg.expressions.Literal;
import com.netflix.iceberg.expressions.Projections;
import com.netflix.iceberg.types.Conversions;
import com.netflix.iceberg.types.Types;
import java.nio.ByteBuffer;
import java.util.List;

public class InclusiveManifestEvaluator {
    private final Types.StructType struct;
    private final Expression expr;
    private transient ThreadLocal<ManifestEvalVisitor> visitors = null;
    private static final boolean ROWS_MIGHT_MATCH = true;
    private static final boolean ROWS_CANNOT_MATCH = false;

    private ManifestEvalVisitor visitor() {
        if (this.visitors == null) {
            this.visitors = ThreadLocal.withInitial(() -> new ManifestEvalVisitor());
        }
        return this.visitors.get();
    }

    public InclusiveManifestEvaluator(PartitionSpec spec, Expression rowFilter) {
        this.struct = spec.partitionType();
        this.expr = Binder.bind(this.struct, Expressions.rewriteNot(Projections.inclusive(spec).project(rowFilter)), true);
    }

    public boolean eval(ManifestFile manifest) {
        return this.visitor().eval(manifest);
    }

    private class ManifestEvalVisitor
    extends ExpressionVisitors.BoundExpressionVisitor<Boolean> {
        private List<ManifestFile.PartitionFieldSummary> stats = null;

        private ManifestEvalVisitor() {
        }

        private boolean eval(ManifestFile manifest) {
            this.stats = manifest.partitions();
            if (this.stats == null) {
                return true;
            }
            return ExpressionVisitors.visit(InclusiveManifestEvaluator.this.expr, this);
        }

        @Override
        public Boolean alwaysTrue() {
            return true;
        }

        @Override
        public Boolean alwaysFalse() {
            return false;
        }

        @Override
        public Boolean not(Boolean result) {
            return result == false;
        }

        @Override
        public Boolean and(Boolean leftResult, Boolean rightResult) {
            return leftResult != false && rightResult != false;
        }

        @Override
        public Boolean or(Boolean leftResult, Boolean rightResult) {
            return leftResult != false || rightResult != false;
        }

        @Override
        public <T> Boolean isNull(BoundReference<T> ref) {
            if (!this.stats.get(ref.pos()).containsNull()) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean notNull(BoundReference<T> ref) {
            ByteBuffer lowerBound = this.stats.get(ref.pos()).lowerBound();
            if (lowerBound == null) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean lt(BoundReference<T> ref, Literal<T> lit) {
            ByteBuffer lowerBound = this.stats.get(ref.pos()).lowerBound();
            if (lowerBound == null) {
                return false;
            }
            Object lower = Conversions.fromByteBuffer(ref.type(), lowerBound);
            int cmp = lit.comparator().compare(lower, lit.value());
            if (cmp >= 0) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean ltEq(BoundReference<T> ref, Literal<T> lit) {
            ByteBuffer lowerBound = this.stats.get(ref.pos()).lowerBound();
            if (lowerBound == null) {
                return false;
            }
            Object lower = Conversions.fromByteBuffer(ref.type(), lowerBound);
            int cmp = lit.comparator().compare(lower, lit.value());
            if (cmp > 0) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean gt(BoundReference<T> ref, Literal<T> lit) {
            ByteBuffer upperBound = this.stats.get(ref.pos()).upperBound();
            if (upperBound == null) {
                return false;
            }
            Object upper = Conversions.fromByteBuffer(ref.type(), upperBound);
            int cmp = lit.comparator().compare(upper, lit.value());
            if (cmp <= 0) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean gtEq(BoundReference<T> ref, Literal<T> lit) {
            ByteBuffer upperBound = this.stats.get(ref.pos()).upperBound();
            if (upperBound == null) {
                return false;
            }
            Object upper = Conversions.fromByteBuffer(ref.type(), upperBound);
            int cmp = lit.comparator().compare(upper, lit.value());
            if (cmp < 0) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean eq(BoundReference<T> ref, Literal<T> lit) {
            ManifestFile.PartitionFieldSummary fieldStats = this.stats.get(ref.pos());
            if (fieldStats.lowerBound() == null) {
                return false;
            }
            Object lower = Conversions.fromByteBuffer(ref.type(), fieldStats.lowerBound());
            int cmp = lit.comparator().compare(lower, lit.value());
            if (cmp > 0) {
                return false;
            }
            Object upper = Conversions.fromByteBuffer(ref.type(), fieldStats.upperBound());
            cmp = lit.comparator().compare(upper, lit.value());
            if (cmp < 0) {
                return false;
            }
            return true;
        }

        @Override
        public <T> Boolean notEq(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }

        @Override
        public <T> Boolean in(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }

        @Override
        public <T> Boolean notIn(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }
    }
}

