/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.expressions;

import com.google.common.base.Preconditions;
import com.netflix.iceberg.expressions.And;
import com.netflix.iceberg.expressions.Expression;
import com.netflix.iceberg.expressions.ExpressionVisitors;
import com.netflix.iceberg.expressions.False;
import com.netflix.iceberg.expressions.Literal;
import com.netflix.iceberg.expressions.NamedReference;
import com.netflix.iceberg.expressions.Not;
import com.netflix.iceberg.expressions.Or;
import com.netflix.iceberg.expressions.RewriteNot;
import com.netflix.iceberg.expressions.True;
import com.netflix.iceberg.expressions.UnboundPredicate;

public class Expressions {
    private Expressions() {
    }

    public static Expression and(Expression left, Expression right) {
        Preconditions.checkNotNull((Object)left, (Object)"Left expression cannot be null.");
        Preconditions.checkNotNull((Object)right, (Object)"Right expression cannot be null.");
        if (left == Expressions.alwaysFalse() || right == Expressions.alwaysFalse()) {
            return Expressions.alwaysFalse();
        }
        if (left == Expressions.alwaysTrue()) {
            return right;
        }
        if (right == Expressions.alwaysTrue()) {
            return left;
        }
        return new And(left, right);
    }

    public static Expression or(Expression left, Expression right) {
        Preconditions.checkNotNull((Object)left, (Object)"Left expression cannot be null.");
        Preconditions.checkNotNull((Object)right, (Object)"Right expression cannot be null.");
        if (left == Expressions.alwaysTrue() || right == Expressions.alwaysTrue()) {
            return Expressions.alwaysTrue();
        }
        if (left == Expressions.alwaysFalse()) {
            return right;
        }
        if (right == Expressions.alwaysFalse()) {
            return left;
        }
        return new Or(left, right);
    }

    public static Expression not(Expression child) {
        Preconditions.checkNotNull((Object)child, (Object)"Child expression cannot be null.");
        if (child == Expressions.alwaysTrue()) {
            return Expressions.alwaysFalse();
        }
        if (child == Expressions.alwaysFalse()) {
            return Expressions.alwaysTrue();
        }
        if (child instanceof Not) {
            return ((Not)child).child();
        }
        return new Not(child);
    }

    public static <T> UnboundPredicate<T> isNull(String name) {
        return new UnboundPredicate(Expression.Operation.IS_NULL, Expressions.ref(name));
    }

    public static <T> UnboundPredicate<T> notNull(String name) {
        return new UnboundPredicate(Expression.Operation.NOT_NULL, Expressions.ref(name));
    }

    public static <T> UnboundPredicate<T> lessThan(String name, T value) {
        return new UnboundPredicate<T>(Expression.Operation.LT, Expressions.ref(name), value);
    }

    public static <T> UnboundPredicate<T> lessThanOrEqual(String name, T value) {
        return new UnboundPredicate<T>(Expression.Operation.LT_EQ, Expressions.ref(name), value);
    }

    public static <T> UnboundPredicate<T> greaterThan(String name, T value) {
        return new UnboundPredicate<T>(Expression.Operation.GT, Expressions.ref(name), value);
    }

    public static <T> UnboundPredicate<T> greaterThanOrEqual(String name, T value) {
        return new UnboundPredicate<T>(Expression.Operation.GT_EQ, Expressions.ref(name), value);
    }

    public static <T> UnboundPredicate<T> equal(String name, T value) {
        return new UnboundPredicate<T>(Expression.Operation.EQ, Expressions.ref(name), value);
    }

    public static <T> UnboundPredicate<T> notEqual(String name, T value) {
        return new UnboundPredicate<T>(Expression.Operation.NOT_EQ, Expressions.ref(name), value);
    }

    public static <T> UnboundPredicate<T> predicate(Expression.Operation op, String name, T value) {
        Preconditions.checkArgument((op != Expression.Operation.IS_NULL && op != Expression.Operation.NOT_NULL ? 1 : 0) != 0, (String)"Cannot create %s predicate inclusive a value", (Object[])new Object[]{op});
        return new UnboundPredicate<T>(op, Expressions.ref(name), value);
    }

    public static <T> UnboundPredicate<T> predicate(Expression.Operation op, String name, Literal<T> lit) {
        Preconditions.checkArgument((op != Expression.Operation.IS_NULL && op != Expression.Operation.NOT_NULL ? 1 : 0) != 0, (String)"Cannot create %s predicate inclusive a value", (Object[])new Object[]{op});
        return new UnboundPredicate<T>(op, Expressions.ref(name), lit);
    }

    public static <T> UnboundPredicate<T> predicate(Expression.Operation op, String name) {
        Preconditions.checkArgument((op == Expression.Operation.IS_NULL || op == Expression.Operation.NOT_NULL ? 1 : 0) != 0, (String)"Cannot create %s predicate without a value", (Object[])new Object[]{op});
        return new UnboundPredicate(op, Expressions.ref(name));
    }

    public static True alwaysTrue() {
        return True.INSTANCE;
    }

    public static False alwaysFalse() {
        return False.INSTANCE;
    }

    public static Expression rewriteNot(Expression expr) {
        return ExpressionVisitors.visit(expr, RewriteNot.get());
    }

    static NamedReference ref(String name) {
        return new NamedReference(name);
    }
}

