/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.expressions;

import com.netflix.iceberg.StructLike;
import com.netflix.iceberg.expressions.Binder;
import com.netflix.iceberg.expressions.BoundReference;
import com.netflix.iceberg.expressions.Expression;
import com.netflix.iceberg.expressions.ExpressionVisitors;
import com.netflix.iceberg.expressions.Literal;
import com.netflix.iceberg.types.Types;
import java.io.Serializable;
import java.util.Comparator;

public class Evaluator
implements Serializable {
    private final Expression expr;
    private transient ThreadLocal<EvalVisitor> visitors = null;

    private EvalVisitor visitor() {
        if (this.visitors == null) {
            this.visitors = ThreadLocal.withInitial(() -> new EvalVisitor());
        }
        return this.visitors.get();
    }

    public Evaluator(Types.StructType struct, Expression unbound) {
        this.expr = Binder.bind(struct, unbound, true);
    }

    public boolean eval(StructLike data) {
        return this.visitor().eval(data);
    }

    private class EvalVisitor
    extends ExpressionVisitors.BoundExpressionVisitor<Boolean> {
        private StructLike struct;

        private EvalVisitor() {
        }

        private boolean eval(StructLike row) {
            this.struct = row;
            return ExpressionVisitors.visit(Evaluator.this.expr, this);
        }

        @Override
        public Boolean alwaysTrue() {
            return true;
        }

        @Override
        public Boolean alwaysFalse() {
            return false;
        }

        @Override
        public Boolean not(Boolean result) {
            return result == false;
        }

        @Override
        public Boolean and(Boolean leftResult, Boolean rightResult) {
            return leftResult != false && rightResult != false;
        }

        @Override
        public Boolean or(Boolean leftResult, Boolean rightResult) {
            return leftResult != false || rightResult != false;
        }

        @Override
        public <T> Boolean isNull(BoundReference<T> ref) {
            return ref.get(this.struct) == null;
        }

        @Override
        public <T> Boolean notNull(BoundReference<T> ref) {
            return ref.get(this.struct) != null;
        }

        @Override
        public <T> Boolean lt(BoundReference<T> ref, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref.get(this.struct), lit.value()) < 0;
        }

        @Override
        public <T> Boolean ltEq(BoundReference<T> ref, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref.get(this.struct), lit.value()) <= 0;
        }

        @Override
        public <T> Boolean gt(BoundReference<T> ref, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref.get(this.struct), lit.value()) > 0;
        }

        @Override
        public <T> Boolean gtEq(BoundReference<T> ref, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref.get(this.struct), lit.value()) >= 0;
        }

        @Override
        public <T> Boolean eq(BoundReference<T> ref, Literal<T> lit) {
            Comparator<T> cmp = lit.comparator();
            return cmp.compare(ref.get(this.struct), lit.value()) == 0;
        }

        @Override
        public <T> Boolean notEq(BoundReference<T> ref, Literal<T> lit) {
            return !((Boolean)this.eq((BoundReference)ref, (Literal)lit)).booleanValue();
        }

        @Override
        public <T> Boolean in(BoundReference<T> ref, Literal<T> lit) {
            throw new UnsupportedOperationException("In is not supported yet");
        }

        @Override
        public <T> Boolean notIn(BoundReference<T> ref, Literal<T> lit) {
            return !((Boolean)this.in((BoundReference)ref, (Literal)lit)).booleanValue();
        }
    }
}

