/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg.expressions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.netflix.iceberg.expressions.BoundPredicate;
import com.netflix.iceberg.expressions.BoundReference;
import com.netflix.iceberg.expressions.Expression;
import com.netflix.iceberg.expressions.ExpressionVisitors;
import com.netflix.iceberg.expressions.Expressions;
import com.netflix.iceberg.expressions.UnboundPredicate;
import com.netflix.iceberg.types.Types;
import java.util.List;
import java.util.Set;

public class Binder {
    private Binder() {
    }

    public static Expression bind(Types.StructType struct, Expression expr, boolean caseSensitive) {
        return ExpressionVisitors.visit(expr, new BindVisitor(struct, caseSensitive));
    }

    static Expression bind(Types.StructType struct, Expression expr) {
        return Binder.bind(struct, expr, true);
    }

    public static Set<Integer> boundReferences(Types.StructType struct, List<Expression> exprs, boolean caseSensitive) {
        if (exprs == null) {
            return ImmutableSet.of();
        }
        ReferenceVisitor visitor = new ReferenceVisitor();
        for (Expression expr : exprs) {
            ExpressionVisitors.visit(Binder.bind(struct, expr, caseSensitive), visitor);
        }
        return visitor.references;
    }

    private static class ReferenceVisitor
    extends ExpressionVisitors.ExpressionVisitor<Set<Integer>> {
        private final Set<Integer> references = Sets.newHashSet();

        private ReferenceVisitor() {
        }

        @Override
        public Set<Integer> alwaysTrue() {
            return this.references;
        }

        @Override
        public Set<Integer> alwaysFalse() {
            return this.references;
        }

        @Override
        public Set<Integer> not(Set<Integer> result) {
            return this.references;
        }

        @Override
        public Set<Integer> and(Set<Integer> leftResult, Set<Integer> rightResult) {
            return this.references;
        }

        @Override
        public Set<Integer> or(Set<Integer> leftResult, Set<Integer> rightResult) {
            return this.references;
        }

        @Override
        public <T> Set<Integer> predicate(BoundPredicate<T> pred) {
            this.references.add(((BoundReference)pred.ref()).fieldId());
            return this.references;
        }
    }

    private static class BindVisitor
    extends ExpressionVisitors.ExpressionVisitor<Expression> {
        private final Types.StructType struct;
        private final boolean caseSensitive;

        private BindVisitor(Types.StructType struct, boolean caseSensitive) {
            this.struct = struct;
            this.caseSensitive = caseSensitive;
        }

        @Override
        public Expression alwaysTrue() {
            return Expressions.alwaysTrue();
        }

        @Override
        public Expression alwaysFalse() {
            return Expressions.alwaysFalse();
        }

        @Override
        public Expression not(Expression result) {
            return Expressions.not(result);
        }

        @Override
        public Expression and(Expression leftResult, Expression rightResult) {
            return Expressions.and(leftResult, rightResult);
        }

        @Override
        public Expression or(Expression leftResult, Expression rightResult) {
            return Expressions.or(leftResult, rightResult);
        }

        @Override
        public <T> Expression predicate(BoundPredicate<T> pred) {
            throw new IllegalStateException("Found already bound predicate: " + pred);
        }

        @Override
        public <T> Expression predicate(UnboundPredicate<T> pred) {
            return pred.bind(this.struct, this.caseSensitive);
        }
    }
}

