/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg;

import com.netflix.iceberg.exceptions.AlreadyExistsException;
import com.netflix.iceberg.exceptions.RuntimeIOException;
import com.netflix.iceberg.io.InputFile;
import com.netflix.iceberg.io.OutputFile;
import com.netflix.iceberg.io.PositionOutputStream;
import com.netflix.iceberg.io.SeekableInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Paths;

public class Files {
    public static OutputFile localOutput(File file) {
        return new LocalOutputFile(file);
    }

    public static OutputFile localOutput(String file) {
        return Files.localOutput(Paths.get(file, new String[0]).toAbsolutePath().toFile());
    }

    public static InputFile localInput(File file) {
        return new LocalInputFile(file);
    }

    public static InputFile localInput(String file) {
        if (file.startsWith("file:")) {
            return Files.localInput(new File(file.replaceFirst("file:", "")));
        }
        return Files.localInput(new File(file));
    }

    private static class PositionFileOutputStream
    extends PositionOutputStream {
        private final RandomAccessFile stream;

        private PositionFileOutputStream(RandomAccessFile stream) {
            this.stream = stream;
        }

        @Override
        public long getPos() throws IOException {
            return this.stream.getFilePointer();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.stream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        @Override
        public void write(int b) throws IOException {
            this.stream.write(b);
        }
    }

    private static class SeekableFileInputStream
    extends SeekableInputStream {
        private final RandomAccessFile stream;

        private SeekableFileInputStream(RandomAccessFile stream) {
            this.stream = stream;
        }

        @Override
        public long getPos() throws IOException {
            return this.stream.getFilePointer();
        }

        @Override
        public void seek(long newPos) throws IOException {
            this.stream.seek(newPos);
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.stream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            if (n > Integer.MAX_VALUE) {
                return this.stream.skipBytes(Integer.MAX_VALUE);
            }
            return this.stream.skipBytes((int)n);
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }
    }

    private static class LocalInputFile
    implements InputFile {
        private final File file;

        private LocalInputFile(File file) {
            this.file = file;
        }

        @Override
        public long getLength() {
            return this.file.length();
        }

        @Override
        public SeekableInputStream newStream() {
            try {
                return new SeekableFileInputStream(new RandomAccessFile(this.file, "r"));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeIOException(e, "Failed to read file: %s", this.file);
            }
        }

        @Override
        public String location() {
            return this.file.toString();
        }

        public String toString() {
            return this.location();
        }
    }

    private static class LocalOutputFile
    implements OutputFile {
        private final File file;

        private LocalOutputFile(File file) {
            this.file = file;
        }

        @Override
        public PositionOutputStream create() {
            if (this.file.exists()) {
                throw new AlreadyExistsException("File already exists: %s", this.file);
            }
            if (!this.file.getParentFile().isDirectory() && !this.file.getParentFile().mkdirs()) {
                throw new RuntimeIOException(String.format("Failed to create the file's directory at %s.", this.file.getParentFile().getAbsolutePath()), new Object[0]);
            }
            try {
                return new PositionFileOutputStream(new RandomAccessFile(this.file, "rw"));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeIOException(e, "Failed to create file: %s", this.file);
            }
        }

        @Override
        public PositionOutputStream createOrOverwrite() {
            if (this.file.exists() && !this.file.delete()) {
                throw new RuntimeIOException("Failed to delete: " + this.file, new Object[0]);
            }
            return this.create();
        }

        @Override
        public String location() {
            return this.file.toString();
        }

        @Override
        public InputFile toInputFile() {
            return Files.localInput(this.file);
        }

        public String toString() {
            return this.location();
        }
    }
}

