/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg;

import com.netflix.iceberg.types.Comparators;

public enum FileFormat {
    ORC("orc"),
    PARQUET("parquet"),
    AVRO("avro");

    private final String ext;

    private FileFormat(String ext) {
        this.ext = "." + ext;
    }

    public String addExtension(String filename) {
        if (filename.endsWith(this.ext)) {
            return filename;
        }
        return filename + this.ext;
    }

    public static FileFormat fromFileName(CharSequence filename) {
        int lastIndex = FileFormat.lastIndexOf('.', filename);
        if (lastIndex < 0) {
            return null;
        }
        CharSequence ext = filename.subSequence(lastIndex, filename.length());
        for (FileFormat format : FileFormat.values()) {
            if (Comparators.charSequences().compare(format.ext, ext) != 0) continue;
            return format;
        }
        return null;
    }

    private static int lastIndexOf(char c, CharSequence seq) {
        for (int i = seq.length() - 1; i >= 0; --i) {
            if (seq.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }
}

