/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iceberg;

import com.netflix.iceberg.FileFormat;
import com.netflix.iceberg.StructLike;
import com.netflix.iceberg.types.Types;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public interface DataFile {
    public static Types.StructType getType(Types.StructType partitionType) {
        return Types.StructType.of(Types.NestedField.required(100, "file_path", Types.StringType.get()), Types.NestedField.required(101, "file_format", Types.StringType.get()), Types.NestedField.required(102, "partition", partitionType), Types.NestedField.required(103, "record_count", Types.LongType.get()), Types.NestedField.required(104, "file_size_in_bytes", Types.LongType.get()), Types.NestedField.required(105, "block_size_in_bytes", Types.LongType.get()), Types.NestedField.optional(106, "file_ordinal", Types.IntegerType.get()), Types.NestedField.optional(107, "sort_columns", Types.ListType.ofRequired(112, Types.IntegerType.get())), Types.NestedField.optional(108, "column_sizes", Types.MapType.ofRequired(117, 118, Types.IntegerType.get(), Types.LongType.get())), Types.NestedField.optional(109, "value_counts", Types.MapType.ofRequired(119, 120, Types.IntegerType.get(), Types.LongType.get())), Types.NestedField.optional(110, "null_value_counts", Types.MapType.ofRequired(121, 122, Types.IntegerType.get(), Types.LongType.get())), Types.NestedField.optional(125, "lower_bounds", Types.MapType.ofRequired(126, 127, Types.IntegerType.get(), Types.BinaryType.get())), Types.NestedField.optional(128, "upper_bounds", Types.MapType.ofRequired(129, 130, Types.IntegerType.get(), Types.BinaryType.get())));
    }

    public CharSequence path();

    public FileFormat format();

    public StructLike partition();

    public long recordCount();

    public long fileSizeInBytes();

    public long blockSizeInBytes();

    public Integer fileOrdinal();

    public List<Integer> sortColumns();

    public Map<Integer, Long> columnSizes();

    public Map<Integer, Long> valueCounts();

    public Map<Integer, Long> nullValueCounts();

    public Map<Integer, ByteBuffer> lowerBounds();

    public Map<Integer, ByteBuffer> upperBounds();

    public DataFile copy();
}

