/*
 * Decompiled with CFR 0.152.
 */
package com.github.banner;

import android.util.SparseArray;
import com.github.banner.BannerHolder;
import com.github.banner.BannerItem;

public class BannerItemManager<T> {
    private SparseArray<BannerItem> helperSparseArray = new SparseArray();

    public void addBannerItem(BannerItem helper) {
        this.helperSparseArray.put(this.helperSparseArray.size(), (Object)helper);
    }

    public boolean hasMultiItem() {
        return this.helperSparseArray != null && this.helperSparseArray.size() > 0;
    }

    public BannerItem getBannerItem(int viewType) {
        return (BannerItem)this.helperSparseArray.get(viewType);
    }

    public int getItemViewType(T item, int position, int dataCount) {
        for (int i = 0; i < this.helperSparseArray.size(); ++i) {
            BannerItem bannerItem = (BannerItem)this.helperSparseArray.valueAt(i);
            if (!bannerItem.isItemType(item, position, dataCount)) continue;
            int viewType = this.helperSparseArray.keyAt(i);
            return viewType;
        }
        throw new IllegalStateException("getItemViewType\u6ca1\u6709\u627e\u5230item\u5e03\u5c40,BannerItem.isItemType()\u8bf7\u6309\u9700\u6c42\u8fd4\u56detrue");
    }

    public void bindData(BannerHolder holder, T item, int position, int dataCount) {
        for (int i = 0; i < this.helperSparseArray.size(); ++i) {
            BannerItem bannerItem = (BannerItem)this.helperSparseArray.valueAt(i);
            if (!bannerItem.isItemType(item, position, dataCount)) continue;
            bannerItem.bindData(holder, item, position, dataCount);
            return;
        }
        throw new IllegalStateException("bindData\u6ca1\u6709\u627e\u5230item\u5e03\u5c40,BannerItem.isItemType()\u8bf7\u6309\u9700\u6c42\u8fd4\u56detrue");
    }
}

