/*
 * Decompiled with CFR 0.152.
 */
package android.sun.security.x509;

import android.sun.security.util.DerOutputStream;
import android.sun.security.util.DerValue;
import android.sun.security.x509.AttributeNameEnumeration;
import android.sun.security.x509.CertAttrSet;
import android.sun.security.x509.Extension;
import android.sun.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;

public class InvalidityDateExtension
extends Extension
implements CertAttrSet<String> {
    public static final String NAME = "InvalidityDate";
    public static final String DATE = "date";
    private Date date;

    private void encodeThis() throws IOException {
        if (this.date == null) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream dos = new DerOutputStream();
        dos.putGeneralizedTime(this.date);
        this.extensionValue = dos.toByteArray();
    }

    public InvalidityDateExtension(Date date) throws IOException {
        this(false, date);
    }

    public InvalidityDateExtension(boolean critical, Date date) throws IOException {
        this.extensionId = PKIXExtensions.InvalidityDate_Id;
        this.critical = critical;
        this.date = date;
        this.encodeThis();
    }

    public InvalidityDateExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.InvalidityDate_Id;
        this.critical = critical;
        this.extensionValue = (byte[])value;
        DerValue val = new DerValue(this.extensionValue);
        this.date = val.getGeneralizedTime();
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (!(obj instanceof Date)) {
            throw new IOException("Attribute must be of type Date.");
        }
        if (!name.equalsIgnoreCase(DATE)) {
            throw new IOException("Name not supported by InvalidityDateExtension");
        }
        this.date = (Date)obj;
        this.encodeThis();
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(DATE)) {
            if (this.date == null) {
                return null;
            }
            return new Date(this.date.getTime());
        }
        throw new IOException("Name not supported by InvalidityDateExtension");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(DATE)) {
            throw new IOException("Name not supported by InvalidityDateExtension");
        }
        this.date = null;
        this.encodeThis();
    }

    @Override
    public String toString() {
        return super.toString() + "    Invalidity Date: " + String.valueOf(this.date);
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.InvalidityDate_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(DATE);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static InvalidityDateExtension toImpl(Extension ext) throws IOException {
        if (ext instanceof InvalidityDateExtension) {
            return (InvalidityDateExtension)ext;
        }
        return new InvalidityDateExtension((Boolean)ext.isCritical(), ext.getValue());
    }
}

