/*
 * Decompiled with CFR 0.152.
 */
package android.sun.security.x509;

import android.sun.security.util.DerInputStream;
import android.sun.security.util.DerOutputStream;
import android.sun.security.util.DerValue;
import android.sun.security.x509.AttributeNameEnumeration;
import android.sun.security.x509.CertAttrSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

public class CertificateVersion
implements CertAttrSet<String> {
    public static final int V1 = 0;
    public static final int V2 = 1;
    public static final int V3 = 2;
    public static final String IDENT = "x509.info.version";
    public static final String NAME = "version";
    public static final String VERSION = "number";
    int version = 0;

    private int getVersion() {
        return this.version;
    }

    private void construct(DerValue derVal) throws IOException {
        if (derVal.isConstructed() && derVal.isContextSpecific()) {
            derVal = derVal.data.getDerValue();
            this.version = derVal.getInteger();
            if (derVal.data.available() != 0) {
                throw new IOException("X.509 version, bad format");
            }
        }
    }

    public CertificateVersion() {
        this.version = 0;
    }

    public CertificateVersion(int version) throws IOException {
        if (version != 0 && version != 1 && version != 2) {
            throw new IOException("X.509 Certificate version " + version + " not supported.\n");
        }
        this.version = version;
    }

    public CertificateVersion(DerInputStream in) throws IOException {
        this.version = 0;
        DerValue derVal = in.getDerValue();
        this.construct(derVal);
    }

    public CertificateVersion(InputStream in) throws IOException {
        this.version = 0;
        DerValue derVal = new DerValue(in);
        this.construct(derVal);
    }

    public CertificateVersion(DerValue val) throws IOException {
        this.version = 0;
        this.construct(val);
    }

    @Override
    public String toString() {
        return "Version: V" + (this.version + 1);
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (this.version == 0) {
            return;
        }
        DerOutputStream tmp = new DerOutputStream();
        tmp.putInteger(this.version);
        DerOutputStream seq = new DerOutputStream();
        seq.write(DerValue.createTag((byte)-128, true, (byte)0), tmp);
        out.write(seq.toByteArray());
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (!(obj instanceof Integer)) {
            throw new IOException("Attribute must be of type Integer.");
        }
        if (!name.equalsIgnoreCase(VERSION)) {
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateVersion.");
        }
        this.version = (Integer)obj;
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(VERSION)) {
            return new Integer(this.getVersion());
        }
        throw new IOException("Attribute name not recognized by CertAttrSet: CertificateVersion.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(VERSION)) {
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateVersion.");
        }
        this.version = 0;
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement(VERSION);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public int compare(int vers) {
        return this.version - vers;
    }
}

