/*
 * Decompiled with CFR 0.152.
 */
package io.github.muntashirakon.adb.android;

import android.content.Context;
import android.net.nsd.NsdManager;
import android.net.nsd.NsdServiceInfo;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import io.github.muntashirakon.adb.android.AndroidUtils;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Collections;
import java.util.Objects;

@RequiresApi(value=16)
public class AdbMdns {
    public static final String SERVICE_TYPE_ADB = "adb";
    public static final String SERVICE_TYPE_TLS_PAIRING = "adb-tls-pairing";
    public static final String SERVICE_TYPE_TLS_CONNECT = "adb-tls-connect";
    @NonNull
    private final Context mContext;
    @NonNull
    private final String mServiceType;
    @NonNull
    private final OnAdbDaemonDiscoveredListener mAdbDaemonDiscoveredListener;
    private final NsdManager.DiscoveryListener mDiscoveryListener;
    private final NsdManager mNsdManager;
    private boolean mRegistered;
    private boolean mRunning;
    @Nullable
    private String mServiceName;

    public AdbMdns(@NonNull Context context, @NonNull String serviceType, @NonNull OnAdbDaemonDiscoveredListener portChangeListener) {
        this.mContext = Objects.requireNonNull(context);
        this.mServiceType = String.format("_%s._tcp", Objects.requireNonNull(serviceType));
        this.mAdbDaemonDiscoveredListener = Objects.requireNonNull(portChangeListener);
        this.mNsdManager = (NsdManager)context.getSystemService("servicediscovery");
        this.mDiscoveryListener = new DiscoveryListener(this);
    }

    public void start() {
        if (this.mRunning) {
            return;
        }
        this.mRunning = true;
        if (!this.mRegistered) {
            this.mNsdManager.discoverServices(this.mServiceType, 1, this.mDiscoveryListener);
        }
    }

    public void stop() {
        if (!this.mRunning) {
            return;
        }
        this.mRunning = false;
        if (this.mRegistered) {
            this.mNsdManager.stopServiceDiscovery(this.mDiscoveryListener);
        }
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    private void onDiscoveryStart() {
        this.mRegistered = true;
    }

    private void onDiscoverStop() {
        this.mRegistered = false;
    }

    private void onServiceFound(NsdServiceInfo serviceInfo) {
        this.mNsdManager.resolveService(serviceInfo, (NsdManager.ResolveListener)new ResolveListener(this));
    }

    private void onServiceLost(NsdServiceInfo serviceInfo) {
        if (this.mServiceName != null && this.mServiceName.equals(serviceInfo.getServiceName())) {
            this.mAdbDaemonDiscoveredListener.onPortChanged(serviceInfo.getHost(), -1);
        }
    }

    private void onServiceResolved(NsdServiceInfo serviceInfo) {
        if (!this.mRunning) {
            return;
        }
        try {
            for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InetAddress inetAddress : Collections.list(networkInterface.getInetAddresses())) {
                    String inetHost = inetAddress.getHostAddress();
                    if (!Objects.equals(inetHost, serviceInfo.getHost().getHostAddress()) || !this.isPortAvailable(serviceInfo.getPort())) continue;
                    this.mServiceName = serviceInfo.getServiceName();
                    this.mAdbDaemonDiscoveredListener.onPortChanged(serviceInfo.getHost(), serviceInfo.getPort());
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    private boolean isPortAvailable(int port) {
        boolean bl;
        ServerSocket socket = new ServerSocket();
        try {
            socket.bind(new InetSocketAddress(AndroidUtils.getHostIpAddress(this.mContext), port), 1);
            bl = false;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return true;
            }
        }
        socket.close();
        return bl;
    }

    public static interface OnAdbDaemonDiscoveredListener {
        public void onPortChanged(@Nullable InetAddress var1, int var2);
    }

    private static class DiscoveryListener
    implements NsdManager.DiscoveryListener {
        @NonNull
        private final AdbMdns mAdbMdns;

        private DiscoveryListener(@NonNull AdbMdns adbMdns) {
            this.mAdbMdns = adbMdns;
        }

        public void onDiscoveryStarted(String serviceType) {
            this.mAdbMdns.onDiscoveryStart();
        }

        public void onStartDiscoveryFailed(String serviceType, int errorCode) {
        }

        public void onDiscoveryStopped(String serviceType) {
            this.mAdbMdns.onDiscoverStop();
        }

        public void onStopDiscoveryFailed(String serviceType, int errorCode) {
        }

        public void onServiceFound(NsdServiceInfo serviceInfo) {
            this.mAdbMdns.onServiceFound(serviceInfo);
        }

        public void onServiceLost(NsdServiceInfo serviceInfo) {
            this.mAdbMdns.onServiceLost(serviceInfo);
        }
    }

    private static class ResolveListener
    implements NsdManager.ResolveListener {
        @NonNull
        private final AdbMdns mAdbMdns;

        private ResolveListener(@NonNull AdbMdns adbMdns) {
            this.mAdbMdns = adbMdns;
        }

        public void onResolveFailed(NsdServiceInfo serviceInfo, int errorCode) {
        }

        public void onServiceResolved(NsdServiceInfo serviceInfo) {
            this.mAdbMdns.onServiceResolved(serviceInfo);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ServiceType {
    }
}

