/*
 * Decompiled with CFR 0.152.
 */
package io.github.muntashirakon.adb;

import io.github.muntashirakon.adb.AdbConnection;
import io.github.muntashirakon.adb.AdbInputStream;
import io.github.muntashirakon.adb.AdbOutputStream;
import io.github.muntashirakon.adb.AdbPairingRequiredException;
import io.github.muntashirakon.adb.AdbProtocol;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class AdbStream
implements Closeable {
    private final AdbConnection mAdbConnection;
    private final int mLocalId;
    private volatile int mRemoteId;
    private final AtomicBoolean mWriteReady;
    private final Queue<byte[]> mReadQueue;
    private final ByteBuffer mReadBuffer;
    private volatile boolean mIsClosed;
    private volatile boolean mPendingClose;

    AdbStream(AdbConnection adbConnection, int localId) throws IOException, InterruptedException, AdbPairingRequiredException {
        this.mAdbConnection = adbConnection;
        this.mLocalId = localId;
        this.mReadQueue = new ConcurrentLinkedQueue<byte[]>();
        this.mReadBuffer = (ByteBuffer)ByteBuffer.allocate(adbConnection.getMaxData()).flip();
        this.mWriteReady = new AtomicBoolean(false);
        this.mIsClosed = false;
    }

    public AdbInputStream openInputStream() {
        return new AdbInputStream(this);
    }

    public AdbOutputStream openOutputStream() {
        return new AdbOutputStream(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPayload(byte[] payload) {
        Queue<byte[]> queue = this.mReadQueue;
        synchronized (queue) {
            this.mReadQueue.add(payload);
            this.mReadQueue.notifyAll();
        }
    }

    void sendReady() throws IOException {
        this.mAdbConnection.sendPacket(AdbProtocol.generateReady(this.mLocalId, this.mRemoteId));
    }

    void updateRemoteId(int remoteId) {
        this.mRemoteId = remoteId;
    }

    void readyForWrite() {
        this.mWriteReady.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyClose(boolean closedByPeer) {
        if (closedByPeer && !this.mReadQueue.isEmpty()) {
            this.mPendingClose = true;
        } else {
            this.mIsClosed = true;
        }
        Object object = this;
        synchronized (object) {
            this.notifyAll();
        }
        object = this.mReadQueue;
        synchronized (object) {
            this.mReadQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (this.mReadBuffer.hasRemaining()) {
            return this.readBuffer(bytes, offset, length);
        }
        Queue<byte[]> queue = this.mReadQueue;
        synchronized (queue) {
            byte[] data;
            while ((data = this.mReadQueue.poll()) == null && !this.mIsClosed) {
                try {
                    this.mReadQueue.wait();
                }
                catch (InterruptedException e) {
                    throw (IOException)new IOException().initCause(e);
                }
            }
            if (data != null) {
                this.mReadBuffer.clear();
                this.mReadBuffer.put(data);
                this.mReadBuffer.flip();
                if (this.mReadBuffer.hasRemaining()) {
                    return this.readBuffer(bytes, offset, length);
                }
            }
            if (this.mIsClosed) {
                throw new IOException("Stream closed.");
            }
            if (this.mPendingClose && this.mReadQueue.isEmpty()) {
                this.mIsClosed = true;
            }
        }
        return -1;
    }

    private int readBuffer(byte[] bytes, int offset, int length) {
        int count = 0;
        for (int i = offset; i < offset + length; ++i) {
            if (!this.mReadBuffer.hasRemaining()) continue;
            bytes[i] = this.mReadBuffer.get();
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] bytes, int offset, int length) throws IOException {
        int maxData;
        AdbStream adbStream = this;
        synchronized (adbStream) {
            while (!this.mIsClosed && !this.mWriteReady.compareAndSet(true, false)) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw (IOException)new IOException().initCause(e);
                }
            }
            if (this.mIsClosed) {
                throw new IOException("Stream closed");
            }
        }
        try {
            maxData = this.mAdbConnection.getMaxData();
        }
        catch (AdbPairingRequiredException | InterruptedException e) {
            throw (IOException)new IOException().initCause(e);
        }
        while (length != 0) {
            if (length <= maxData) {
                this.mAdbConnection.sendPacket(AdbProtocol.generateWrite(this.mLocalId, this.mRemoteId, bytes, offset, length));
                offset += length;
                length = 0;
                continue;
            }
            this.mAdbConnection.sendPacket(AdbProtocol.generateWrite(this.mLocalId, this.mRemoteId, bytes, offset, maxData));
            offset += maxData;
            length -= maxData;
        }
    }

    public void flush() throws IOException {
        if (this.mIsClosed) {
            throw new IOException("Stream closed");
        }
        this.mAdbConnection.flushPacket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        AdbStream adbStream = this;
        synchronized (adbStream) {
            if (this.mIsClosed) {
                return;
            }
            this.notifyClose(false);
        }
        this.mAdbConnection.sendPacket(AdbProtocol.generateClose(this.mLocalId, this.mRemoteId));
    }

    public boolean isClosed() {
        return this.mIsClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        AdbStream adbStream = this;
        synchronized (adbStream) {
            if (this.mIsClosed) {
                throw new IOException("Stream closed.");
            }
            if (this.mReadBuffer.hasRemaining()) {
                return this.mReadBuffer.remaining();
            }
            byte[] data = this.mReadQueue.peek();
            int n = data == null ? 0 : data.length;
            return n;
        }
    }
}

