/*
 * Decompiled with CFR 0.152.
 */
package io.github.muntashirakon.adb;

import android.content.Context;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.WorkerThread;
import io.github.muntashirakon.adb.AdbConnection;
import io.github.muntashirakon.adb.AdbPairingRequiredException;
import io.github.muntashirakon.adb.AdbStream;
import io.github.muntashirakon.adb.KeyPair;
import io.github.muntashirakon.adb.PairingConnectionCtx;
import io.github.muntashirakon.adb.StringCompat;
import io.github.muntashirakon.adb.android.AdbMdns;
import java.io.Closeable;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.DestroyFailedException;

public abstract class AbsAdbConnectionManager
implements Closeable {
    private final Object mLock = new Object();
    @Nullable
    private AdbConnection mAdbConnection;
    private String mHostAddress = "127.0.0.1";
    private int mApi = 1;
    private long mTimeout = Long.MAX_VALUE;
    private TimeUnit mTimeoutUnit = TimeUnit.MILLISECONDS;
    private boolean mThrowOnUnauthorised = false;

    @NonNull
    protected abstract PrivateKey getPrivateKey();

    @NonNull
    protected abstract Certificate getCertificate();

    @NonNull
    protected abstract String getDeviceName();

    @CallSuper
    public void setHostAddress(@NonNull String hostAddress) {
        this.mHostAddress = Objects.requireNonNull(hostAddress);
    }

    @NonNull
    public String getHostAddress() {
        return this.mHostAddress;
    }

    public void setApi(int api) {
        this.mApi = api;
    }

    public int getApi() {
        return this.mApi;
    }

    @CallSuper
    public void setTimeout(long timeout, TimeUnit unit) {
        this.mTimeout = timeout;
        this.mTimeoutUnit = unit;
    }

    public long getTimeout() {
        return this.mTimeoutUnit.toMillis(this.mTimeout);
    }

    @NonNull
    public TimeUnit getTimeoutUnit() {
        return this.mTimeoutUnit;
    }

    @CallSuper
    public void setThrowOnUnauthorised(boolean throwOnUnauthorised) {
        this.mThrowOnUnauthorised = throwOnUnauthorised;
    }

    public boolean isThrowOnUnauthorised() {
        return this.mThrowOnUnauthorised;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallSuper
    @Nullable
    public AdbConnection getAdbConnection() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAdbConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAdbConnection != null && this.mAdbConnection.isConnected() && this.mAdbConnection.isConnectionEstablished();
        }
    }

    @WorkerThread
    @RequiresApi(value=16)
    public boolean connectTls(@NonNull Context context, long timeoutMillis) throws IOException, InterruptedException, AdbPairingRequiredException {
        return this.autoConnect(context, "adb-tls-connect", timeoutMillis);
    }

    @WorkerThread
    @RequiresApi(value=16)
    public boolean connectTcp(@NonNull Context context, long timeoutMillis) throws IOException, InterruptedException, AdbPairingRequiredException {
        return this.autoConnect(context, "adb", timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @RequiresApi(value=16)
    public boolean autoConnect(@NonNull Context context, long timeoutMillis) throws IOException, InterruptedException, AdbPairingRequiredException {
        Object object = this.mLock;
        synchronized (object) {
            AtomicInteger atomicPort = new AtomicInteger(-1);
            AtomicReference<Object> atomicHostAddress = new AtomicReference<Object>(null);
            CountDownLatch resolveHostAndPort = new CountDownLatch(1);
            AdbMdns adbMdnsTcp = new AdbMdns(context, "adb", (hostAddress, port) -> {
                if (hostAddress != null) {
                    atomicHostAddress.set(hostAddress.getHostAddress());
                    atomicPort.set(port);
                }
                resolveHostAndPort.countDown();
            });
            adbMdnsTcp.start();
            AdbMdns adbMdnsTls = new AdbMdns(context, "adb-tls-connect", (hostAddress, port) -> {
                if (hostAddress != null) {
                    atomicHostAddress.set(hostAddress.getHostAddress());
                    atomicPort.set(port);
                }
                resolveHostAndPort.countDown();
            });
            adbMdnsTls.start();
            try {
                if (!resolveHostAndPort.await(timeoutMillis, TimeUnit.MILLISECONDS)) {
                    throw new InterruptedException("Timed out while trying to find a valid host address and port");
                }
            }
            finally {
                adbMdnsTcp.stop();
                adbMdnsTls.stop();
            }
            String host = atomicHostAddress.get();
            int port2 = atomicPort.get();
            if (host == null || port2 == -1) {
                throw new IOException("Could not find any valid host address or port");
            }
            this.mHostAddress = host;
            this.mAdbConnection = new AdbConnection.Builder(host, port2).setApi(this.mApi).setKeyPair(this.getAdbKeyPair()).setDeviceName(Objects.requireNonNull(this.getDeviceName())).build();
            return this.mAdbConnection.connect(this.mTimeout, this.mTimeoutUnit, this.mThrowOnUnauthorised);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @RequiresApi(value=16)
    private boolean autoConnect(@NonNull Context context, @NonNull String serviceType, long timeoutMillis) throws IOException, InterruptedException, AdbPairingRequiredException {
        Object object = this.mLock;
        synchronized (object) {
            AtomicInteger atomicPort = new AtomicInteger(-1);
            AtomicReference<Object> atomicHostAddress = new AtomicReference<Object>(null);
            CountDownLatch resolveHostAndPort = new CountDownLatch(1);
            AdbMdns adbMdns = new AdbMdns(context, serviceType, (hostAddress, port) -> {
                if (hostAddress != null) {
                    atomicHostAddress.set(hostAddress.getHostAddress());
                    atomicPort.set(port);
                }
                resolveHostAndPort.countDown();
            });
            adbMdns.start();
            try {
                if (!resolveHostAndPort.await(timeoutMillis, TimeUnit.MILLISECONDS)) {
                    throw new InterruptedException("Timed out while trying to find a valid host address and port");
                }
            }
            finally {
                adbMdns.stop();
            }
            String host = atomicHostAddress.get();
            int port2 = atomicPort.get();
            if (host == null || port2 == -1) {
                throw new IOException("Could not find any valid host address or port");
            }
            this.mHostAddress = host;
            this.mAdbConnection = new AdbConnection.Builder(host, port2).setApi(this.mApi).setKeyPair(this.getAdbKeyPair()).setDeviceName(Objects.requireNonNull(this.getDeviceName())).build();
            return this.mAdbConnection.connect(this.mTimeout, this.mTimeoutUnit, this.mThrowOnUnauthorised);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public boolean connect(int port) throws IOException, InterruptedException, AdbPairingRequiredException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isConnected()) {
                return false;
            }
            this.mAdbConnection = new AdbConnection.Builder(this.mHostAddress, port).setApi(this.mApi).setKeyPair(this.getAdbKeyPair()).setDeviceName(Objects.requireNonNull(this.getDeviceName())).build();
            return this.mAdbConnection.connect(this.mTimeout, this.mTimeoutUnit, this.mThrowOnUnauthorised);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public boolean connect(@NonNull String host, int port) throws IOException, InterruptedException, AdbPairingRequiredException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isConnected()) {
                return false;
            }
            this.mHostAddress = host;
            this.mAdbConnection = new AdbConnection.Builder(host, port).setApi(this.mApi).setKeyPair(this.getAdbKeyPair()).setDeviceName(Objects.requireNonNull(this.getDeviceName())).build();
            return this.mAdbConnection.connect(this.mTimeout, this.mTimeoutUnit, this.mThrowOnUnauthorised);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAdbConnection != null) {
                this.mAdbConnection.close();
                this.mAdbConnection = null;
            }
        }
    }

    @WorkerThread
    @NonNull
    public AdbStream openStream(String destination) throws IOException, InterruptedException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAdbConnection != null && this.mAdbConnection.isConnected()) {
                try {
                    return this.mAdbConnection.open(destination);
                }
                catch (AdbPairingRequiredException e) {
                    throw new IllegalStateException(e);
                }
            }
            throw new IOException("Not connected to ADB.");
        }
    }

    @NonNull
    public AdbStream openStream(int service, String ... args) throws IOException, InterruptedException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAdbConnection != null && this.mAdbConnection.isConnected()) {
                try {
                    return this.mAdbConnection.open(service, args);
                }
                catch (AdbPairingRequiredException e) {
                    throw new IllegalStateException(e);
                }
            }
            throw new IOException("Not connected to ADB.");
        }
    }

    @WorkerThread
    @RequiresApi(value=9)
    public boolean pair(int port, @NonNull String pairingCode) throws Exception {
        return this.pair(this.mHostAddress, port, pairingCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @RequiresApi(value=9)
    public boolean pair(@NonNull String host, int port, @NonNull String pairingCode) throws Exception {
        Object object = this.mLock;
        synchronized (object) {
            KeyPair keyPair = this.getAdbKeyPair();
            try (PairingConnectionCtx pairingClient = new PairingConnectionCtx(Objects.requireNonNull(host), port, StringCompat.getBytes(Objects.requireNonNull(pairingCode), "UTF-8"), keyPair, this.getDeviceName());){
                pairingClient.start();
            }
            return true;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.getPrivateKey().destroy();
        }
        catch (NoSuchMethodError | DestroyFailedException e) {
            e.printStackTrace();
        }
        if (this.mAdbConnection != null) {
            this.mAdbConnection.close();
            this.mAdbConnection = null;
        }
    }

    @NonNull
    private KeyPair getAdbKeyPair() {
        return new KeyPair(Objects.requireNonNull(this.getPrivateKey()), Objects.requireNonNull(this.getCertificate()));
    }
}

