/*
 * Decompiled with CFR 0.152.
 */
package io.github.muntashirakon.adb.android;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import androidx.annotation.NonNull;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class AndroidUtils {
    private static final String GOLDFISH = "goldfish";
    private static final String RANCHU = "ranchu";
    private static final String SDK = "sdk";

    public static boolean isEmulator(@NonNull Context context) {
        if (Build.PRODUCT.contains(SDK)) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 8 && (Build.HARDWARE.contains(GOLDFISH) || Build.HARDWARE.contains(RANCHU))) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 3) {
            String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            return androidId == null;
        }
        return false;
    }

    @NonNull
    public static String getHostIpAddress(@NonNull Context context) {
        String ipAddress;
        if (AndroidUtils.isEmulator(context)) {
            return "10.0.2.2";
        }
        if (Build.VERSION.SDK_INT >= 19) {
            ipAddress = InetAddress.getLoopbackAddress().getHostAddress();
        } else {
            try {
                ipAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                ipAddress = null;
            }
        }
        if (ipAddress == null || ipAddress.equals("::1")) {
            return "127.0.0.1";
        }
        return ipAddress;
    }
}

