/*
 * Decompiled with CFR 0.152.
 */
package io.github.muntashirakon.adb;

import android.annotation.SuppressLint;
import android.os.Build;
import androidx.annotation.NonNull;
import io.github.muntashirakon.adb.KeyPair;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;

final class SslUtils {
    private static boolean customConscrypt = false;
    private static SSLContext sslContext;

    SslUtils() {
    }

    public static boolean isCustomConscrypt() {
        return customConscrypt;
    }

    @SuppressLint(value={"TrulyRandom"})
    @NonNull
    public static SSLContext getSslContext(KeyPair keyPair) throws NoSuchAlgorithmException, KeyManagementException {
        if (sslContext != null) {
            return sslContext;
        }
        try {
            Class<?> providerClass = Class.forName("org.conscrypt.OpenSSLProvider");
            Provider openSslProvder = (Provider)providerClass.newInstance();
            sslContext = SSLContext.getInstance("TLSv1.3", openSslProvder);
            customConscrypt = true;
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (Throwable e) {
            if (Build.VERSION.SDK_INT < 29) {
                throw new NoSuchAlgorithmException("TLSv1.3 isn't supported on your platform. Use custom Conscrypt library instead.");
            }
            sslContext = SSLContext.getInstance("TLSv1.3");
            customConscrypt = false;
        }
        System.out.println("Using " + (customConscrypt ? "custom" : "default") + " TLSv1.3 provider...");
        sslContext.init(new KeyManager[]{SslUtils.getKeyManager(keyPair)}, new X509TrustManager[]{SslUtils.getAllAcceptingTrustManager()}, new SecureRandom());
        return sslContext;
    }

    @NonNull
    private static KeyManager getKeyManager(final KeyPair keyPair) {
        return new X509ExtendedKeyManager(){
            private final String mAlias = "key";

            @Override
            public String[] getClientAliases(String keyType, Principal[] issuers) {
                return null;
            }

            @Override
            public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
                for (String keyType : keyTypes) {
                    if (!keyType.equals("RSA")) continue;
                    return "key";
                }
                return null;
            }

            @Override
            public String[] getServerAliases(String keyType, Principal[] issuers) {
                return null;
            }

            @Override
            public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
                return null;
            }

            @Override
            public X509Certificate[] getCertificateChain(String alias) {
                if (this.mAlias.equals(alias)) {
                    return new X509Certificate[]{(X509Certificate)keyPair.getCertificate()};
                }
                return null;
            }

            @Override
            public PrivateKey getPrivateKey(String alias) {
                if (this.mAlias.equals(alias)) {
                    return keyPair.getPrivateKey();
                }
                return null;
            }
        };
    }

    @SuppressLint(value={"TrustAllX509TrustManager"})
    @NonNull
    private static X509TrustManager getAllAcceptingTrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }
}

