/*
 * Decompiled with CFR 0.152.
 */
package io.github.muntashirakon.adb;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import io.github.muntashirakon.adb.StringCompat;
import io.github.muntashirakon.crypto.spake2.Spake2Context;
import io.github.muntashirakon.crypto.spake2.Spake2Role;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import javax.security.auth.Destroyable;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.crypto.params.KeyParameter;

@RequiresApi(value=9)
class PairingAuthCtx
implements Destroyable {
    private static final byte[] CLIENT_NAME = StringCompat.getBytes("adb pair client\u0000", "UTF-8");
    private static final byte[] SERVER_NAME = StringCompat.getBytes("adb pair server\u0000", "UTF-8");
    private static final byte[] INFO = StringCompat.getBytes("adb pairing_auth aes-128-gcm key", "UTF-8");
    private static final int HKDF_KEY_LENGTH = 16;
    public static final int GCM_IV_LENGTH = 12;
    private final byte[] mMsg;
    private final Spake2Context mSpake2Ctx;
    private final byte[] mSecretKey = new byte[16];
    private long mDecIv = 0L;
    private long mEncIv = 0L;
    private boolean mIsDestroyed = false;

    @Nullable
    public static PairingAuthCtx createAlice(byte[] password) {
        Spake2Context spake25519 = new Spake2Context(Spake2Role.Alice, CLIENT_NAME, SERVER_NAME);
        try {
            return new PairingAuthCtx(spake25519, password);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            return null;
        }
    }

    @VisibleForTesting
    @Nullable
    public static PairingAuthCtx createBob(byte[] password) {
        Spake2Context spake25519 = new Spake2Context(Spake2Role.Bob, SERVER_NAME, CLIENT_NAME);
        try {
            return new PairingAuthCtx(spake25519, password);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            return null;
        }
    }

    private PairingAuthCtx(Spake2Context spake25519, byte[] password) throws IllegalArgumentException, IllegalStateException {
        this.mSpake2Ctx = spake25519;
        this.mMsg = this.mSpake2Ctx.generateMessage(password);
    }

    public byte[] getMsg() {
        return this.mMsg;
    }

    public boolean initCipher(byte[] theirMsg) throws IllegalArgumentException, IllegalStateException {
        if (this.mIsDestroyed) {
            return false;
        }
        byte[] keyMaterial = this.mSpake2Ctx.processMessage(theirMsg);
        if (keyMaterial == null) {
            return false;
        }
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator((Digest)new SHA256Digest());
        hkdf.init((DerivationParameters)new HKDFParameters(keyMaterial, null, INFO));
        hkdf.generateBytes(this.mSecretKey, 0, this.mSecretKey.length);
        return true;
    }

    @Nullable
    public byte[] encrypt(@NonNull byte[] in) {
        return this.encryptDecrypt(true, in, ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN).putLong(this.mEncIv++).array());
    }

    @Nullable
    public byte[] decrypt(@NonNull byte[] in) {
        return this.encryptDecrypt(false, in, ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN).putLong(this.mDecIv++).array());
    }

    @Override
    public boolean isDestroyed() {
        return this.mIsDestroyed;
    }

    @Override
    public void destroy() {
        this.mIsDestroyed = true;
        Arrays.fill(this.mSecretKey, (byte)0);
        this.mSpake2Ctx.destroy();
    }

    @Nullable
    private byte[] encryptDecrypt(boolean forEncryption, @NonNull byte[] in, @NonNull byte[] iv) {
        if (this.mIsDestroyed) {
            return null;
        }
        AEADParameters spec = new AEADParameters(new KeyParameter(this.mSecretKey), this.mSecretKey.length * 8, iv);
        GCMBlockCipher cipher = new GCMBlockCipher((BlockCipher)new AESEngine());
        cipher.init(forEncryption, (CipherParameters)spec);
        byte[] out = new byte[cipher.getOutputSize(in.length)];
        int newOffset = cipher.processBytes(in, 0, in.length, out, 0);
        try {
            cipher.doFinal(out, newOffset);
        }
        catch (InvalidCipherTextException e) {
            return null;
        }
        return out;
    }
}

